/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.config.PayConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class PayCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.pay";
    private static final String COMMAND_NAME = "pay";
    private static final long CONFIRMATION_TIMEOUT = 15000L;
    private static final Map<UUID, PendingPayment> pendingPayments = new HashMap<UUID, PendingPayment>();
    private final PlayerLanguageManager langManager;
    private final PayConfig config;
    private final EconomyManager economyManager;
    private final Plugin plugin;

    public PayCommand(Plugin plugin, PlayerLanguageManager langManager, PayConfig config, EconomyManager economyManager) {
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.pay.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player senderPlayer = (Player)sender;
        if (!senderPlayer.hasPermission(PERMISSION)) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.no-economy", "<red>\u00a7c\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length != 2) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.usage", "<yellow>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " <player> <amount>")));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.player-not-found", "<red>Player not found: <white>{player}", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        if (target.getUniqueId().equals(senderPlayer.getUniqueId())) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.self-payment", "<red>You cannot pay yourself!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.invalid-amount", "<red>Invalid amount: <white>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", args[1])));
            return true;
        }
        if (amount <= 0.0) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.positive-amount", "<red>Amount must be positive!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (this.economyManager.getBalance(senderPlayer) < amount) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.not-enough", "<red>You don't have enough money!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ((CompletableFuture)this.economyManager.hasPaymentsDisabled(target.getUniqueId().toString()).thenAccept(disabled -> {
            if (disabled.booleanValue()) {
                senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.target-disabled", "<red>{player} has disabled payments!", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
                return;
            }
            ((CompletableFuture)this.economyManager.hasPayConfirmDisabled(senderPlayer.getUniqueId().toString()).thenAccept(confirmDisabled -> Bukkit.getScheduler().runTask(this.plugin, () -> {
                if (confirmDisabled.booleanValue()) {
                    this.processPayment(senderPlayer, target, amount);
                } else {
                    this.processPaymentWithConfirmation(senderPlayer, target, amount);
                }
            }))).exceptionally(ex -> {
                senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.error", "<red>Error checking confirmation status. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
                return null;
            });
        })).exceptionally(ex -> {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.error", "<red>Error checking payment status. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
            return null;
        });
        return true;
    }

    private void processPaymentWithConfirmation(Player senderPlayer, OfflinePlayer target, double amount) {
        UUID senderUUID = senderPlayer.getUniqueId();
        if (pendingPayments.containsKey(senderUUID)) {
            PendingPayment pending = pendingPayments.get(senderUUID);
            if (System.currentTimeMillis() - pending.timestamp > 15000L) {
                pendingPayments.remove(senderUUID);
                senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.confirmation-expired", "<red>Previous payment confirmation expired. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            if (pending.target.equals(target.getUniqueId()) && pending.amount == amount) {
                pendingPayments.remove(senderUUID);
                this.processPayment(senderPlayer, target, amount);
                return;
            }
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.pending-other", "<yellow>You already have a pending payment to <white>{player} <yellow>for <green>{amount}", LanguageManager.ComponentPlaceholder.of("{player}", Bukkit.getOfflinePlayer((UUID)pending.target).getName()), LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(pending.amount))));
            return;
        }
        pendingPayments.put(senderUUID, new PendingPayment(target.getUniqueId(), amount));
        senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.confirm-message", "<green>Click to confirm: Pay <white>{amount} <green>to <white>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
        senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.confirm-instruction", "<gray>Type <white>{command} <gray>again to confirm.", LanguageManager.ComponentPlaceholder.of("{command}", "/pay " + target.getName() + " " + amount)));
    }

    private void processPayment(Player senderPlayer, OfflinePlayer target, double amount) {
        EconomyResponse withdrawResponse = this.economyManager.withdraw(senderPlayer, amount);
        if (!withdrawResponse.success()) {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.transaction-failed", "<red>Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", withdrawResponse.errorMessage)));
            return;
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            EconomyResponse depositResponse = this.economyManager.deposit(targetPlayer, amount);
            if (!depositResponse.success()) {
                this.economyManager.deposit(senderPlayer, amount);
                senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.transaction-failed", "<red>Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", depositResponse.errorMessage)));
                return;
            }
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.success-sender", "<green>You paid <white>{amount} <green>to <white>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
            targetPlayer.sendMessage(this.langManager.getMessageFor(targetPlayer, "commands.pay.success-target", "<green>You received <white>{amount} <green>from <white>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", senderPlayer.getName())));
        } else {
            senderPlayer.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.pay.offline-target", "<red>Cannot pay offline players.", new LanguageManager.ComponentPlaceholder[0]));
            this.economyManager.deposit(senderPlayer, amount);
        }
    }

    static class PendingPayment {
        private final UUID target;
        private final double amount;
        private final long timestamp;

        public PendingPayment(UUID target, double amount) {
            this.target = target;
            this.amount = amount;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

