/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.PTimeConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class PTimeCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.ptime";
    private static final String PERMISSION_DAY = "essc.command.ptime.day";
    private static final String PERMISSION_NIGHT = "essc.command.ptime.night";
    private static final String PERMISSION_RESET = "essc.command.ptime.reset";
    private final PlayerLanguageManager langManager;
    private final PTimeConfig config;
    private final CommandDataStorage dataStorage;

    public PTimeCommand(PlayerLanguageManager langManager, PTimeConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String option;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.ptime.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.usage", "<red>Usage: <white>/ptime <day|night|reset>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        switch (option = args[0].toLowerCase()) {
            case "day": {
                if (!player.hasPermission(PERMISSION_DAY)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_DAY)));
                    return true;
                }
                player.setPlayerTime(this.config.dayTime(), false);
                break;
            }
            case "night": {
                if (!player.hasPermission(PERMISSION_NIGHT)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_NIGHT)));
                    return true;
                }
                player.setPlayerTime(this.config.nightTime(), false);
                break;
            }
            case "reset": {
                if (!player.hasPermission(PERMISSION_RESET)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_RESET)));
                    return true;
                }
                player.resetPlayerTime();
                break;
            }
            default: {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.invalid-option", "<red>Invalid option! Use: <white>day, night, or reset", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
        }
        player.sendMessage(this.langManager.getMessageFor(player, "commands.ptime.success", "<green>Personal time set to <gold>{option}", LanguageManager.ComponentPlaceholder.of("{option}", option.toUpperCase())));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "ptime", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "ptime", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "ptime", "last_option", option);
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            if (player.hasPermission(PERMISSION_DAY) && "day".startsWith(partial)) {
                completions.add("day");
            }
            if (player.hasPermission(PERMISSION_NIGHT) && "night".startsWith(partial)) {
                completions.add("night");
            }
            if (player.hasPermission(PERMISSION_RESET) && "reset".startsWith(partial)) {
                completions.add("reset");
            }
        }
        return completions;
    }
}

