/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.commands.config.NotesConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.notes.storage.NotesStorage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class NotesCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.notes";
    private final PlayerLanguageManager langManager;
    private final NotesConfig config;
    private final NotesStorage storage;

    public NotesCommand(PlayerLanguageManager langManager, NotesConfig config, NotesStorage storage) {
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.notes.only-player", "<red>Only players can use notes.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            this.showUsage(player);
            return true;
        }
        String noteName = args[0].toLowerCase();
        if (args.length == 1) {
            this.viewNote(player, noteName);
        } else {
            String content = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            this.saveNote(player, noteName, content);
        }
        return true;
    }

    private void showUsage(Player player) {
        player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.usage", "<yellow>Usage:</yellow> /notes <name> [content]", new LanguageManager.ComponentPlaceholder[0]));
        this.storage.getNotes(player.getUniqueId()).thenAccept(notes -> {
            if (notes.isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.list-empty", "<yellow>You have no notes.", new LanguageManager.ComponentPlaceholder[0]));
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.list-header", "<yellow>Your notes:</yellow> " + String.join((CharSequence)", ", notes.keySet()), new LanguageManager.ComponentPlaceholder[0]));
            }
        });
    }

    private void viewNote(Player player, String noteName) {
        this.storage.getNote(player.getUniqueId(), noteName).thenAccept(optContent -> {
            if (optContent.isPresent()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.view", "<yellow>Note '<green>{name}</green>':</yellow> {content}", LanguageManager.ComponentPlaceholder.of("{name}", noteName), LanguageManager.ComponentPlaceholder.of("{content}", optContent.get())));
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.not-found", "<red>Note '<yellow>{name}</yellow>' not found.", LanguageManager.ComponentPlaceholder.of("{name}", noteName)));
            }
        });
    }

    private void saveNote(Player player, String noteName, String content) {
        this.storage.saveNote(player.getUniqueId(), noteName, content).thenAccept(v -> player.sendMessage(this.langManager.getMessageFor(player, "commands.notes.saved", "<green>Saved note '<yellow>{name}</yellow>':</yellow> {content}", LanguageManager.ComponentPlaceholder.of("{name}", noteName), LanguageManager.ComponentPlaceholder.of("{content}", content))));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            return List.of();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            CompletableFuture<Map<String, String>> notesFuture = this.storage.getNotes(player.getUniqueId());
            try {
                Map<String, String> notes = notesFuture.get();
                return notes.keySet().stream().filter(name -> name.startsWith(input)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return List.of();
            }
        }
        return List.of();
    }
}

