/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.commands.config.MuteConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.mute.storage.MuteStorage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MuteCommand
extends CommandModule
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final MuteStorage storage;
    private final MuteConfig config;

    public MuteCommand(JavaPlugin plugin, PlayerLanguageManager langManager, CommandDataStorage commandStorage, MuteStorage storage, MuteConfig config) {
        super(commandStorage, langManager);
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::checkExpiredMutes, 20L, config.checkInterval.toSeconds() * 20L);
    }

    @Override
    protected String getCommandName() {
        return "mute";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String reason;
        String durationStr;
        if (!sender.hasPermission("essc.command.mute")) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.mute")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.mute.usage", "<red>Usage: <yellow>/mute <player> <duration> <reason> | /mute <player> <reason> [perm]", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target.getName() == null) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.mute.not-found", "<red>Player not found.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length >= 3 && args[1].matches("\\d+[smhdSMHD].*")) {
            durationStr = args[1];
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        } else {
            durationStr = "perm";
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        }
        long expiresAt = this.parseDuration(durationStr);
        ((CompletableFuture)this.storage.isMuted(target.getUniqueId()).thenCompose(isMuted -> {
            if (isMuted.booleanValue()) {
                return this.storage.getMuteData(target.getUniqueId()).thenApply(opt -> opt.map(MuteStorage.MuteData::reason).orElse("No reason"));
            }
            return CompletableFuture.completedFuture(null);
        })).thenAccept(existingReason -> {
            if (existingReason != null) {
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.mute.already-muted", "<red><yellow>{player}</yellow> is already muted for <white>{reason}</white>.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()), LanguageManager.ComponentPlaceholder.of("{reason}", existingReason)));
                return;
            }
            this.storage.mutePlayer(target.getUniqueId(), reason, expiresAt).thenRun(() -> {
                String durationDisplay = this.formatDurationDisplay(expiresAt);
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.mute.success", "<yellow>You muted <green>{player}</green> <gray>for <white>{reason}</white> <yellow>({duration})</yellow>.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()), LanguageManager.ComponentPlaceholder.of("{reason}", reason), LanguageManager.ComponentPlaceholder.of("{duration}", durationDisplay)));
                if (target.isOnline()) {
                    Player player = target.getPlayer();
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.mute.notify", "<red>You have been muted! <gray>Reason: <white>{reason}</white> <yellow>({duration})</yellow>", LanguageManager.ComponentPlaceholder.of("{reason}", reason), LanguageManager.ComponentPlaceholder.of("{duration}", durationDisplay)));
                }
            });
        });
        return true;
    }

    private long parseDuration(String input) {
        if (input.equalsIgnoreCase("perm") || input.equalsIgnoreCase("permanent")) {
            return -1L;
        }
        long totalMs = 0L;
        StringBuilder currentNumber = new StringBuilder();
        for (char c : input.toCharArray()) {
            long multiplier;
            if (Character.isDigit(c)) {
                currentNumber.append(c);
                continue;
            }
            if (!Character.isLetter(c)) continue;
            if (currentNumber.length() == 0) {
                return System.currentTimeMillis();
            }
            long value = Long.parseLong(currentNumber.toString());
            currentNumber.setLength(0);
            switch (Character.toLowerCase(c)) {
                case 's': {
                    long l = 1000L;
                    break;
                }
                case 'm': {
                    long l = 60000L;
                    break;
                }
                case 'h': {
                    long l = 3600000L;
                    break;
                }
                case 'd': {
                    long l = 86400000L;
                    break;
                }
                default: {
                    long l = multiplier = 0L;
                }
            }
            if (multiplier == 0L) {
                return System.currentTimeMillis();
            }
            totalMs += value * multiplier;
        }
        if (currentNumber.length() > 0) {
            totalMs += Long.parseLong(currentNumber.toString()) * 1000L;
        }
        if (totalMs == 0L) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() + totalMs;
    }

    private String formatDurationDisplay(long expiresAt) {
        if (expiresAt == -1L) {
            return "Permanent";
        }
        long remainingMs = expiresAt - System.currentTimeMillis();
        if (remainingMs <= 0L) {
            return "Expired";
        }
        long seconds = remainingMs / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        StringBuilder display = new StringBuilder();
        if (days > 0L) {
            display.append(days).append("d ");
        }
        if (hours % 24L > 0L) {
            display.append(hours % 24L).append("h ");
        }
        if (minutes % 60L > 0L && days == 0L) {
            display.append(minutes % 60L).append("m ");
        }
        if (seconds % 60L > 0L && hours == 0L && days == 0L) {
            display.append(seconds % 60L).append("s");
        }
        return display.toString().trim();
    }

    private void checkExpiredMutes() {
        this.storage.getAllMutedUUIDs().thenAccept(uuids -> uuids.forEach(uuid -> this.storage.isMuted((UUID)uuid).thenAccept(isMuted -> {
            if (!isMuted.booleanValue()) {
                this.storage.unmutePlayer((UUID)uuid).thenRun(() -> {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player != null && player.isOnline()) {
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.unmute.notify", "<green>You have been unmuted!", new LanguageManager.ComponentPlaceholder[0]));
                    }
                });
            }
        })));
    }

    public CompletableFuture<Void> unmute(UUID uuid) {
        return this.storage.unmutePlayer(uuid);
    }

    public CompletableFuture<Boolean> isMuted(UUID uuid) {
        return this.storage.isMuted(uuid);
    }

    public CompletableFuture<Optional<String>> getMuteReason(UUID uuid) {
        return this.storage.getMuteData(uuid).thenApply(opt -> opt.map(MuteStorage.MuteData::reason));
    }
}

