/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.CommandDataStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class MagnetStorage {
    private final CommandDataStorage commandDataStorage;
    private final Set<UUID> activeMagnets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Plugin plugin;

    public MagnetStorage(Plugin plugin, CommandDataStorage commandDataStorage) {
        this.plugin = plugin;
        this.commandDataStorage = commandDataStorage;
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadPlayerState(player);
        }
    }

    private void loadPlayerState(Player player) {
        ((CompletableFuture)this.commandDataStorage.getState(player.getUniqueId(), "magnet", "enabled").thenAccept(opt -> {
            if (opt.isPresent() && Boolean.parseBoolean((String)opt.get())) {
                this.activeMagnets.add(player.getUniqueId());
            }
        })).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to load magnet state for " + player.getName() + ": " + ex.getMessage());
            return null;
        });
    }

    public void onPlayerJoin(Player player) {
        this.loadPlayerState(player);
    }

    public void onPlayerQuit(Player player) {
        this.activeMagnets.remove(player.getUniqueId());
    }

    public CompletableFuture<Void> enableMagnet(Player player) {
        this.activeMagnets.add(player.getUniqueId());
        return this.commandDataStorage.setState(player.getUniqueId(), "magnet", "enabled", "true");
    }

    public CompletableFuture<Void> disableMagnet(Player player) {
        this.activeMagnets.remove(player.getUniqueId());
        return this.commandDataStorage.deleteState(player.getUniqueId(), "magnet", "enabled");
    }

    public boolean isEnabled(Player player) {
        return this.activeMagnets.contains(player.getUniqueId());
    }

    public Set<Player> getActivePlayers() {
        HashSet<Player> players = new HashSet<Player>();
        for (UUID id : this.activeMagnets) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null || !player.isOnline()) continue;
            players.add(player);
        }
        return players;
    }
}

