/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.MagnetConfig;
import net.godlycow.org.commands.impl.MagnetStorage;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public final class MagnetListener
implements Listener {
    private final MagnetConfig config;
    private final MagnetStorage storage;
    private final Plugin plugin;
    private BukkitRunnable magnetTask;

    public MagnetListener(Plugin plugin, MagnetConfig config, MagnetStorage storage) {
        this.plugin = plugin;
        this.config = config;
        this.storage = storage;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        this.startMagnetTask();
    }

    private void startMagnetTask() {
        this.magnetTask = new BukkitRunnable(){

            public void run() {
                for (Player player : MagnetListener.this.storage.getActivePlayers()) {
                    if (!player.isOnline() || player.isDead()) {
                        MagnetListener.this.storage.disableMagnet(player);
                        continue;
                    }
                    player.getWorld().getNearbyEntities(player.getLocation(), MagnetListener.this.config.radius, MagnetListener.this.config.radius, MagnetListener.this.config.radius).stream().filter(entity -> entity instanceof Item).map(entity -> (Item)entity).filter(item -> !item.isGlowing()).forEach(item -> {
                        Vector direction = player.getLocation().toVector().subtract(item.getLocation().toVector()).normalize().multiply(MagnetListener.this.config.speed);
                        item.setVelocity(direction);
                    });
                }
            }
        };
        this.magnetTask.runTaskTimer(this.plugin, 0L, (long)this.config.tickInterval);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.storage.onPlayerJoin(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.storage.onPlayerQuit(event.getPlayer());
    }

    public void stop() {
        if (this.magnetTask != null) {
            this.magnetTask.cancel();
        }
    }
}

