/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.commands.config.LobbyConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.lobby.helper.AnimationHelper;
import net.godlycow.org.lobby.storage.LobbyStorage;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LobbyCommand
extends CommandModule
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final LobbyStorage lobbyStorage;
    private final LobbyConfig config;
    private final Map<UUID, Long> cooldownMap = new ConcurrentHashMap<UUID, Long>();

    public LobbyCommand(JavaPlugin plugin, PlayerLanguageManager langManager, CommandDataStorage commandStorage, LobbyStorage lobbyStorage, LobbyConfig config) {
        super(commandStorage, langManager);
        this.plugin = plugin;
        this.langManager = langManager;
        this.lobbyStorage = lobbyStorage;
        this.config = config;
    }

    @Override
    protected String getCommandName() {
        return "lobby";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-players", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.handleTeleport(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "set": {
                this.handleSetCommand(player, args);
                break;
            }
            case "remove": {
                this.handleRemoveCommand(player, args);
                break;
            }
            case "world": {
                this.handleWorldCommand(player, args);
                break;
            }
            default: {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.unknown", "<red>Unknown command. Usage: /lobby, /lobby set, /lobby remove", new LanguageManager.ComponentPlaceholder[0]));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return suggestions;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            if (player.hasPermission("essc.command.lobby")) {
                suggestions.add("teleport");
            }
            if (player.hasPermission("essc.command.lobby.set")) {
                suggestions.add("set");
            }
            if (player.hasPermission("essc.command.lobby.remove")) {
                suggestions.add("remove");
            }
            if (player.hasPermission("essc.command.lobby.world") && this.config.isPerWorld()) {
                suggestions.add("world");
            }
        } else if (args.length == 2) {
            String sub = args[0].toLowerCase();
            if ((sub.equals("set") || sub.equals("remove")) && this.config.isPerWorld()) {
                suggestions.add("world");
            } else if (sub.equals("world") && player.hasPermission("essc.command.lobby.world")) {
                Bukkit.getWorlds().forEach(world -> suggestions.add(world.getName()));
            }
        }
        return suggestions;
    }

    private void handleTeleport(Player player) {
        if (!player.hasPermission("essc.command.lobby")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.lobby")));
            return;
        }
        if (!this.checkCooldown(player)) {
            return;
        }
        String worldKey = this.config.isPerWorld() ? player.getWorld().getName() : "global";
        ((CompletableFuture)this.lobbyStorage.hasLobby(worldKey).thenAccept(has -> {
            if (!has.booleanValue()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.no-lobby", "<red>No lobby has been set.", new LanguageManager.ComponentPlaceholder[0])));
                return;
            }
            this.performTeleport(player);
        })).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to check lobby: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        });
    }

    private boolean checkCooldown(Player player) {
        long cooldownSeconds;
        long elapsed;
        if (player.hasPermission("essc.command.lobby.bypass-cooldown")) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        long now = Instant.now().getEpochSecond();
        Long lastUsed = this.cooldownMap.get(uuid);
        if (lastUsed != null && (elapsed = now - lastUsed) < (cooldownSeconds = this.config.getCooldown().getSeconds())) {
            long remaining = cooldownSeconds - elapsed;
            player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.cooldown-active", "<red>Please wait <yellow>{time}</yellow> seconds before teleporting again.", LanguageManager.ComponentPlaceholder.of("{time}", String.valueOf(remaining))));
            this.plugin.getLogger().fine("Lobby cooldown active for " + player.getName() + ": " + remaining + "s remaining");
            return false;
        }
        this.cooldownMap.put(uuid, now);
        this.plugin.getLogger().fine("Lobby cooldown set for " + player.getName() + " at timestamp " + now);
        return true;
    }

    private void performTeleport(Player player) {
        String worldKey = this.config.isPerWorld() ? player.getWorld().getName() : "global";
        ((CompletableFuture)this.lobbyStorage.getLobby(worldKey).thenAccept(optLocation -> optLocation.ifPresent(lobby -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.config.isAnimationEnabled()) {
                AnimationHelper.playTeleportAnimation((Plugin)this.plugin, player, this.config.getAnimation());
            }
            player.teleport(lobby);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.teleported", "<green>Teleported to lobby!", new LanguageManager.ComponentPlaceholder[0]));
        })))).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to teleport player: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        });
    }

    private void handleSetCommand(Player player, String[] args) {
        if (!player.hasPermission("essc.command.lobby.set")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.lobby.set")));
            return;
        }
        Location loc = player.getLocation();
        boolean isWorldSpecific = args.length >= 2 && "world".equalsIgnoreCase(args[1]) && this.config.isPerWorld();
        CompletableFuture<Void> saveFuture = isWorldSpecific ? this.lobbyStorage.setWorldLobby(player.getWorld().getName(), loc) : this.lobbyStorage.setLobby(loc);
        ((CompletableFuture)saveFuture.thenRun(() -> {
            String messageKey = isWorldSpecific ? "commands.lobby.set-world" : "commands.lobby.set";
            Component message = isWorldSpecific ? this.langManager.getMessageFor(player, messageKey, "<green>Lobby set!", LanguageManager.ComponentPlaceholder.of("{world}", player.getWorld().getName())) : this.langManager.getMessageFor(player, messageKey, "<green>Lobby set!", new LanguageManager.ComponentPlaceholder[0]);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(message));
        })).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to set lobby: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        });
    }

    private void handleRemoveCommand(Player player, String[] args) {
        if (!player.hasPermission("essc.command.lobby.remove")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.lobby.remove")));
            return;
        }
        boolean isWorldSpecific = args.length >= 2 && "world".equalsIgnoreCase(args[1]) && this.config.isPerWorld();
        String world = isWorldSpecific ? player.getWorld().getName() : null;
        ((CompletableFuture)this.lobbyStorage.removeLobby(world).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.removed", "<yellow>Lobby removed.", new LanguageManager.ComponentPlaceholder[0]))))).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to remove lobby: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        });
    }

    private void handleWorldCommand(Player player, String[] args) {
        if (!player.hasPermission("essc.command.lobby.world") || !this.config.isPerWorld()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.lobby.world")));
            return;
        }
        if (args.length < 2) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.usage-world", "<red>Usage: <yellow>/lobby world <world-name>", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        String worldName = args[1];
        if (this.plugin.getServer().getWorld(worldName) == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.world-not-found", "<red>World <yellow>{world}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
            return;
        }
        ((CompletableFuture)this.lobbyStorage.setWorldLobby(worldName, player.getLocation()).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.set-world", "<green>Lobby for world <yellow>{world}</yellow> set!", LanguageManager.ComponentPlaceholder.of("{world}", worldName)))))).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to set world lobby: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        });
    }
}

