/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.LoadWorldConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class LoadWorldCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.loadworld";
    private final PlayerLanguageManager langManager;
    private final LoadWorldConfig config;

    public LoadWorldCommand(PlayerLanguageManager langManager, LoadWorldConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean loaded;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.loadworld.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.loadworld.usage", "<red>Usage: /loadworld <world>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String worldName = args[0];
        if (Bukkit.getWorld((String)worldName) != null) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.loadworld.already-loaded", "<red>World <yellow>{world}</yellow> is already loaded!", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
            return true;
        }
        boolean bl = loaded = Bukkit.getServer().createWorld(new WorldCreator(worldName)) != null;
        if (loaded) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.loadworld.success", "<green>Successfully loaded world <yellow>{world}</yellow>.", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
        } else {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.loadworld.failed", "<red>Failed to load world <yellow>{world}</yellow>!", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
        }
        return true;
    }
}

