/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import java.util.stream.Collectors;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.ItemInfoConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemInfoCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.iteminfo";
    private final PlayerLanguageManager langManager;
    private final ItemInfoConfig config;
    private final CommandDataStorage dataStorage;

    public ItemInfoCommand(PlayerLanguageManager langManager, ItemInfoConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.iteminfo.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.no-item", "<red>You must hold an item in your main hand.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.header", "<dark_aqua>\u2261 <bold>Item Information</bold> <dark_aqua>\u2261", new LanguageManager.ComponentPlaceholder[0]));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.type", "<gray>Type: <white>{type}", LanguageManager.ComponentPlaceholder.of("{type}", item.getType().toString())));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.amount", "<gray>Amount: <white>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(item.getAmount()))));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasDisplayName()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.name", "<gray>Name: <white>{name}", LanguageManager.ComponentPlaceholder.of("{name}", meta.getDisplayName())));
            }
            if (meta.hasLore() && meta.lore() != null) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.lore-header", "<gray>\u2261 <bold>Lore</bold> <gray>\u2261", new LanguageManager.ComponentPlaceholder[0]));
                String loreText = meta.lore().stream().map(line -> PlainTextComponentSerializer.plainText().serialize(line)).collect(Collectors.joining("\n"));
                player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.lore-content", "<white>{lore}", LanguageManager.ComponentPlaceholder.of("{lore}", loreText)));
            }
            if (!meta.getEnchants().isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.enchants-header", "<gray>\u2261 <bold>Enchantments</bold> <gray>\u2261", new LanguageManager.ComponentPlaceholder[0]));
                for (Enchantment enchant : meta.getEnchants().keySet()) {
                    int level = meta.getEnchantLevel(enchant);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.enchant-line", "<yellow>\u2726 <white>{enchant} <gray>Level {level}", LanguageManager.ComponentPlaceholder.of("{enchant}", enchant.getKey().getKey()), LanguageManager.ComponentPlaceholder.of("{level}", String.valueOf(level))));
                }
            }
            if (!meta.getItemFlags().isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.flags-header", "<gray>\u2261 <bold>Item Flags</bold> <gray>\u2261", new LanguageManager.ComponentPlaceholder[0]));
                for (ItemFlag flag : meta.getItemFlags()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.flag-line", "<yellow>- <gray>{flag}", LanguageManager.ComponentPlaceholder.of("{flag}", flag.name())));
                }
            }
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.iteminfo.no-meta", "<gray>No additional metadata.", new LanguageManager.ComponentPlaceholder[0]));
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "iteminfo", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "iteminfo", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "iteminfo", "last_item", item.getType().toString());
        });
        return true;
    }
}

