/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.godlycow.org.commands.config.InvseeConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public final class InvseeCommand
implements TabExecutor {
    private static final String PERMISSION = "essc.command.invsee";
    private final PlayerLanguageManager langManager;
    private final InvseeConfig config;

    public InvseeCommand(PlayerLanguageManager langManager, InvseeConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.invsee.only-player", "<#B22222>\u274c Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.no-permission", "<#B22222>\u274c You need permission <#FFD900>{permission}</#FFD900>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        if (args.length > 1 || args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(player);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.player-not-found", "<#B22222>\u274c Player not found: <white>{player}</white>", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        player.openInventory((Inventory)target.getInventory());
        player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.success", "<#50DB00>\u2714 Viewing <white>{player}</white>'s inventory.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
        return true;
    }

    private void sendHelpMessage(Player player) {
        Component help = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(this.langManager.getMessageFor(player, "commands.invsee.help.header", "<#FFD900><bold>=== Invsee Command Help ===</bold></#FFD900>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.invsee.help.description", "<#FFD900>Description: <white>View another player's inventory.</white>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.invsee.help.usage", "<#FFD900>Usage:</#FFD900> <white>/invsee <player></white>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.invsee.help.permission", "<#FFD900>Required Permission:</#FFD900> <white>{permission}</white>", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.invsee.help.examples.header", "<#FFD900>Examples:</#FFD900>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.invsee.help.examples.example1", "  <white>/invsee {player}</white> <gray>- View player's inventory</gray>", LanguageManager.ComponentPlaceholder.of("{player}", "Steve")))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.invsee.help.footer", "<gray>Use <white>/invsee help</white> to see this message again.</gray>", new LanguageManager.ComponentPlaceholder[0]));
        player.sendMessage(help);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            if ("help".startsWith(input)) {
                completions.add("help");
            }
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            return completions;
        }
        return Collections.emptyList();
    }
}

