/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.godlycow.org.commands.config.InvClearConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public final class InvClearCommand
implements TabExecutor {
    private static final String PERMISSION = "essc.command.invclear";
    private final PlayerLanguageManager langManager;
    private final InvClearConfig config;

    public InvClearCommand(PlayerLanguageManager langManager, InvClearConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.invclear.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invclear.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        Player target = player;
        if (args.length >= 1 && (target = Bukkit.getPlayer((String)args[0])) == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invclear.player-not-found", "<red>Player not found: <yellow>{player}</yellow>", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        target.getInventory().clear();
        target.sendMessage(this.langManager.getMessageFor(target, "commands.invclear.cleared", "<green>Your inventory has been cleared.", new LanguageManager.ComponentPlaceholder[0]));
        if (!target.equals((Object)player)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invclear.cleared-other", "<green>Cleared <white>{player}</white>'s inventory.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

