/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.HealConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class HealCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.heal";
    private static final String PERMISSION_OTHERS = "essc.command.heal.others";
    private final PlayerLanguageManager langManager;
    private final HealConfig config;

    public HealCommand(PlayerLanguageManager langManager, HealConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player senderPlayer = sender instanceof Player ? (Player)sender : null;
        boolean hasHealSelf = sender.hasPermission(PERMISSION);
        boolean hasHealOthers = sender.hasPermission(PERMISSION_OTHERS);
        if (args.length == 0) {
            if (senderPlayer == null) {
                sender.sendMessage(this.langManager.getMessageFor(null, "commands.heal.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
            if (!hasHealSelf) {
                sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.heal.no-permission", "<red>You don't have permission to heal yourself!", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
            this.healPlayer(senderPlayer);
            sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.heal.success-self", "<green>You have been healed!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 1) {
            if (!hasHealOthers) {
                sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.heal.no-permission-others", "<red>You don't have permission to heal other players!", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.heal.player-not-found", "<red>Player not found: {player}", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
                return true;
            }
            this.healPlayer(target);
            sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.heal.success-other", "<green>You healed <white>{player}</white>!", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
            target.sendMessage(this.langManager.getMessageFor(target, "commands.heal.success-healed", "<green>You have been healed by <white>{healer}</white>!", LanguageManager.ComponentPlaceholder.of("{healer}", sender.getName())));
            return true;
        }
        sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.heal.usage", "<red>Usage: /heal [player]", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }

    private void healPlayer(Player player) {
        player.setHealth(player.getMaxHealth());
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.setFireTicks(0);
        player.setRemainingAir(player.getMaximumAir());
        player.setFreezeTicks(0);
    }
}

