/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FlyCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final CommandDataStorage storage;
    private final String commandName = "fly";

    public FlyCommand(JavaPlugin plugin, PlayerLanguageManager langManager, CommandDataStorage storage) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.langManager.getMessageFor(null, "commands.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(msg.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("essc.command.fly")) {
            Component msg = this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.fly"));
            player.sendMessage(msg);
            return true;
        }
        this.toggleFlight(player);
        return true;
    }

    private void toggleFlight(Player player) {
        UUID playerId = player.getUniqueId();
        this.storage.getState(playerId, "fly", "enabled").thenAccept(optState -> {
            boolean currentlyEnabled = optState.map(Boolean::parseBoolean).orElse(false);
            boolean newState = !currentlyEnabled;
            ((CompletableFuture)this.storage.setState(playerId, "fly", "enabled", String.valueOf(newState)).thenRun(() -> {
                this.applyFlightState(player, newState);
                String messageKey = newState ? "commands.fly.enabled" : "commands.fly.disabled";
                String defaultMessage = newState ? "<green>\u2708 Flight enabled! Press SPACE twice to fly." : "<red>\u2708 Flight disabled.";
                Component msg = this.langManager.getMessageFor(player, messageKey, defaultMessage, new LanguageManager.ComponentPlaceholder[0]);
                player.sendMessage(msg);
            })).exceptionally(ex -> {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.fly.error", "<red>Error saving flight state. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
                this.plugin.getLogger().warning("Failed to save fly state for " + player.getName() + ": " + ex.getMessage());
                return null;
            });
        });
    }

    public void applyFlightState(Player player, boolean enabled) {
        player.setAllowFlight(enabled);
        if (enabled && !player.isOnGround()) {
            player.setFlying(true);
        } else if (!enabled) {
            player.setFlying(false);
        }
    }

    public void loadFlightState(Player player) {
        this.storage.getState(player.getUniqueId(), "fly", "enabled").thenAccept(optState -> {
            boolean enabled = optState.map(Boolean::parseBoolean).orElse(false);
            this.applyFlightState(player, enabled);
            this.plugin.getLogger().fine("Loaded flight state for " + player.getName() + ": " + enabled);
        });
    }
}

