/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.FireballConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class FireballCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.fireball";
    private final PlayerLanguageManager langManager;
    private final FireballConfig config;
    private final CommandDataStorage dataStorage;

    public FireballCommand(PlayerLanguageManager langManager, FireballConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.fireball.only-player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(player, "commands.fireball.no-permission", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            player.sendMessage(message);
            return true;
        }
        player.launchProjectile(Fireball.class);
        Component message = this.langManager.getMessageFor(player, "commands.fireball.launched", "Fireball launched!", new LanguageManager.ComponentPlaceholder[0]);
        player.sendMessage(message);
        this.trackUsage(player.getUniqueId(), "self", 1);
        return true;
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "fireball", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "fireball", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "fireball", "last_type", type);
            this.dataStorage.setState(playerId, "fireball", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

