/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.FakeopConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class FakeopCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.fakeop";
    private final PlayerLanguageManager langManager;
    private final FakeopConfig config;
    private final CommandDataStorage dataStorage;

    public FakeopCommand(PlayerLanguageManager langManager, FakeopConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.fakeop.no-permission", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            sender.sendMessage(message);
            return true;
        }
        if (args.length != 1) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.fakeop.usage", "Usage: /fakeop <player>", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message);
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            Component message = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.fakeop.target-not-found", "Player not found.", LanguageManager.ComponentPlaceholder.of("{target}", args[0]));
            sender.sendMessage(message);
            return true;
        }
        Component fakeMessage = this.langManager.getMessageFor(null, "commands.fakeop.fake-message", "[Server: Made {target} a server operator]", LanguageManager.ComponentPlaceholder.of("{target}", target.getName()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(fakeMessage);
        }
        Component confirmMessage = this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.fakeop.success", "Fake OP sent to {target}", LanguageManager.ComponentPlaceholder.of("{target}", target.getName()));
        sender.sendMessage(confirmMessage);
        this.trackUsage(target.getUniqueId(), "fakeop", 1);
        return true;
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "fakeop", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "fakeop", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "fakeop", "last_type", type);
            this.dataStorage.setState(playerId, "fakeop", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

