/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.ExtConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ExtCommand
implements CommandExecutor {
    private static final String PERMISSION_NODE = "essc.command.ext";
    private static final String PERMISSION_OTHERS = "essc.command.ext.others";
    private final PlayerLanguageManager langManager;
    private final ExtConfig config;

    public ExtCommand(PlayerLanguageManager langManager, ExtConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean isSelf;
        Player target;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.ext.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_NODE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.ext.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_NODE)));
            return true;
        }
        if (args.length == 0) {
            target = player;
            isSelf = true;
        } else {
            if (!player.hasPermission(PERMISSION_OTHERS)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.ext.no-permission-others", "<red>You need permission <yellow>{permission}</yellow> to extinguish other players!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_OTHERS)));
                return true;
            }
            target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.ext.player-not-found", "<red>Player not found!", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
            isSelf = false;
        }
        target.setFireTicks(0);
        target.sendMessage(this.langManager.getMessageFor(target, "commands.ext.self", "<green>You have been extinguished!", new LanguageManager.ComponentPlaceholder[0]));
        if (!isSelf) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.ext.target", "<green>You extinguished {target}!", LanguageManager.ComponentPlaceholder.of("{target}", target.getName())));
        }
        return true;
    }
}

