/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.List;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.ExplosionConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExplosionCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.explosion";
    private final PlayerLanguageManager langManager;
    private final ExplosionConfig config;
    private final CommandDataStorage dataStorage;

    public ExplosionCommand(PlayerLanguageManager langManager, ExplosionConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.explosion.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(player, "commands.explosion.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            player.sendMessage(message);
            return true;
        }
        if (args.length < 1) {
            Component message = this.langManager.getMessageFor(player, "commands.explosion.no-radius", "<yellow>Please specify a radius!", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
            return true;
        }
        try {
            float radius = Float.parseFloat(args[0]);
            player.getWorld().createExplosion(player.getLocation(), radius);
            Component message = this.langManager.getMessageFor(player, "commands.explosion.created", "<green>Explosion created with radius {radius}!", LanguageManager.ComponentPlaceholder.of("{radius}", args[0]));
            player.sendMessage(message);
            this.trackUsage(player.getUniqueId(), "explosion", 1);
        }
        catch (NumberFormatException e) {
            Component message = this.langManager.getMessageFor(player, "commands.explosion.invalid-radius", "<red>Invalid radius: {input}", LanguageManager.ComponentPlaceholder.of("{input}", args[0]));
            player.sendMessage(message);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return List.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        }
        return List.of();
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "explosion", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "explosion", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "explosion", "last_type", type);
            this.dataStorage.setState(playerId, "explosion", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

