/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.EditSignConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class EditSignCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.editsign";
    private final PlayerLanguageManager langManager;
    private final EditSignConfig config;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public EditSignCommand(PlayerLanguageManager langManager, EditSignConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.editsign.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.editsign.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        Block target = player.getTargetBlockExact(5);
        if (target == null || !target.getType().name().contains("SIGN")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.editsign.not-looking-at-sign", "<red>You are not looking at a sign.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.editsign.usage", "<yellow>Usage: /editsign <line1>|<line2>|<line3>|<line4>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String input = String.join((CharSequence)" ", args);
        String[] lines = input.split("\\|");
        Sign sign = (Sign)target.getState();
        for (int i = 0; i < Math.min(lines.length, 4); ++i) {
            String line = LegacyComponentSerializer.legacySection().serialize((Component)this.mm.deserialize(lines[i].trim()));
            sign.setLine(i, line);
        }
        sign.update();
        player.sendMessage(this.langManager.getMessageFor(player, "commands.editsign.success", "<green>Sign updated successfully!", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }
}

