/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.List;
import net.godlycow.org.commands.config.EcoConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class EcoCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.eco";
    private final PlayerLanguageManager langManager;
    private final EcoConfig config;
    private final EconomyManager economyManager;
    private final JavaPlugin plugin;

    public EcoCommand(JavaPlugin plugin, PlayerLanguageManager langManager, EcoConfig config, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
    }

    private OfflinePlayer getTargetPlayer(String name) {
        Player online = Bukkit.getPlayer((String)name);
        if (online != null) {
            return online;
        }
        OfflinePlayer offline = Bukkit.getOfflinePlayerIfCached((String)name);
        if (offline == null) {
            offline = Bukkit.getOfflinePlayer((String)name);
        }
        return offline;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.no-permission", "<#FF2424>You need permission <#c0f0ff>{permission}<#FF2424>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.no-economy", "<#FF2424>Economy system is not available!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length < 2) {
            this.sendUsageMessage(sender, label, player);
            return true;
        }
        OfflinePlayer target = this.getTargetPlayer(args[1]);
        if (target.getName() == null) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.player-not-found", "<#FF2424>Player not found: <#c0f0ff>{player}", LanguageManager.ComponentPlaceholder.of("{player}", args[1])));
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "give": {
                this.handleGive(sender, player, target, args, label);
                break;
            }
            case "take": {
                this.handleTake(sender, player, target, args, label);
                break;
            }
            case "reset": {
                this.handleReset(sender, player, target);
                break;
            }
            case "set": {
                this.handleSet(sender, player, target, args, label);
                break;
            }
            default: {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.unknown-subcommand", "<#FF2424>Unknown subcommand: <#c0f0ff>{sub}\n<#708090>Available: give, take, set, reset", LanguageManager.ComponentPlaceholder.of("{sub}", sub)));
            }
        }
        return true;
    }

    private void sendUsageMessage(CommandSender sender, String label, Player player) {
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.usage", "<#279CF5>Usage: <white>/" + label + " give <player> <amount>\n<white>/" + label + " take <player> <amount>\n<white>/" + label + " set <player> <amount>\n<white>/" + label + " reset <player>", new LanguageManager.ComponentPlaceholder[0]));
    }

    private void handleGive(CommandSender sender, Player player, OfflinePlayer target, String[] args, String label) {
        if (args.length < 3) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.give-usage", "<#279CF5>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " give <player> <amount>")));
            return;
        }
        double amount = this.parseAmount(args[2], sender, player);
        if (amount < 0.0) {
            return;
        }
        if (target instanceof Player) {
            Player onlineTarget = (Player)target;
            EconomyResponse response = this.economyManager.deposit(onlineTarget, amount);
            if (response.success()) {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.give-success", "<#279CF5>Gave <#c0f0ff>{amount} <#279CF5>to <#c0f0ff>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
                if (!sender.equals((Object)target)) {
                    onlineTarget.sendMessage(this.langManager.getMessageFor(onlineTarget, "commands.eco.give-received", "<#279CF5>You received <#c0f0ff>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
                }
                this.plugin.getLogger().info(String.format("[Eco] %s gave %s %.2f to %s", sender.getName(), this.economyManager.getEconomyName(), amount, target.getName()));
            } else {
                this.sendTransactionFailedMessage(sender, player, response.errorMessage);
            }
        } else {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.offline-player", "<#FF2424>Cannot modify balance of offline players.", new LanguageManager.ComponentPlaceholder[0]));
        }
    }

    private void handleTake(CommandSender sender, Player player, OfflinePlayer target, String[] args, String label) {
        if (args.length < 3) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.take-usage", "<#279CF5>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " take <player> <amount>")));
            return;
        }
        double amount = this.parseAmount(args[2], sender, player);
        if (amount < 0.0) {
            return;
        }
        if (target instanceof Player) {
            Player onlineTarget = (Player)target;
            EconomyResponse response = this.economyManager.withdraw(onlineTarget, amount);
            if (response.success()) {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.take-success", "<#FF2424>Took <#c0f0ff>{amount} <#FF2424>from <#c0f0ff>{player}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount)), LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
                if (!sender.equals((Object)target)) {
                    onlineTarget.sendMessage(this.langManager.getMessageFor(onlineTarget, "commands.eco.take-taken", "<#FF2424>{amount} <#708090>was taken from your balance", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
                }
                this.plugin.getLogger().info(String.format("[Eco] %s took %s %.2f from %s", sender.getName(), this.economyManager.getEconomyName(), amount, target.getName()));
            } else {
                this.sendTransactionFailedMessage(sender, player, response.errorMessage);
            }
        } else {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.offline-player", "<#FF2424>Cannot modify balance of offline players.", new LanguageManager.ComponentPlaceholder[0]));
        }
    }

    private void handleSet(CommandSender sender, Player player, OfflinePlayer target, String[] args, String label) {
        if (args.length < 3) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.set-usage", "<#279CF5>Usage: <white>{usage}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " set <player> <amount>")));
            return;
        }
        double amount = this.parseAmount(args[2], sender, player);
        if (amount < 0.0) {
            return;
        }
        if (target instanceof Player) {
            Player onlineTarget = (Player)target;
            double currentBalance = this.economyManager.getBalance(onlineTarget);
            if (amount > currentBalance) {
                EconomyResponse response = this.economyManager.deposit(onlineTarget, amount - currentBalance);
                if (response.success()) {
                    this.sendSetSuccessMessage(sender, player, onlineTarget, amount);
                } else {
                    this.sendTransactionFailedMessage(sender, player, response.errorMessage);
                }
            } else if (amount < currentBalance) {
                EconomyResponse response = this.economyManager.withdraw(onlineTarget, currentBalance - amount);
                if (response.success()) {
                    this.sendSetSuccessMessage(sender, player, onlineTarget, amount);
                } else {
                    this.sendTransactionFailedMessage(sender, player, response.errorMessage);
                }
            } else {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.set-success", "<#279CF5>Set balance for <#c0f0ff>{player} <#279CF5>to <#c0f0ff>{amount}", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()), LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
            }
        } else {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.offline-player", "<#FF2424>Cannot modify balance of offline players.", new LanguageManager.ComponentPlaceholder[0]));
        }
    }

    private void handleReset(CommandSender sender, Player player, OfflinePlayer target) {
        if (target instanceof Player) {
            Player onlineTarget = (Player)target;
            double bal = this.economyManager.getBalance(onlineTarget);
            if (bal > 0.0) {
                EconomyResponse response = this.economyManager.withdraw(onlineTarget, bal);
                if (response.success()) {
                    sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.reset-success", "<#279CF5>Reset balance for <#c0f0ff>{player}", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
                    this.plugin.getLogger().info(String.format("[Eco] %s reset balance for %s", sender.getName(), target.getName()));
                } else {
                    this.sendTransactionFailedMessage(sender, player, response.errorMessage);
                }
            } else {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.reset-already-zero", "<#708090>Balance for <#c0f0ff>{player} <#708090>is already zero", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
            }
        } else {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.offline-player", "<#FF2424>Cannot modify balance of offline players.", new LanguageManager.ComponentPlaceholder[0]));
        }
    }

    private void sendSetSuccessMessage(CommandSender sender, Player senderPlayer, Player target, double amount) {
        sender.sendMessage(this.langManager.getMessageFor(senderPlayer, "commands.eco.set-success", "<#279CF5>Set balance for <#c0f0ff>{player} <#279CF5>to <#c0f0ff>{amount}", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()), LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
        if (!sender.equals((Object)target)) {
            target.sendMessage(this.langManager.getMessageFor(target, "commands.eco.set-received", "<#279CF5>Your balance was set to <#c0f0ff>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
        }
    }

    private void sendTransactionFailedMessage(CommandSender sender, Player player, String errorMessage) {
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.transaction-failed", "<#FF2424>Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", errorMessage)));
    }

    private double parseAmount(String input, CommandSender sender, Player player) {
        try {
            double amount = Double.parseDouble(input);
            if (amount < 0.0) {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.negative-amount", "<#FF2424>Amount cannot be negative!", new LanguageManager.ComponentPlaceholder[0]));
                return -1.0;
            }
            if (amount > this.config.maxTransactionAmount) {
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.amount-too-high", "<#FF2424>Amount exceeds maximum allowed: {max}", LanguageManager.ComponentPlaceholder.of("{max}", this.economyManager.format(this.config.maxTransactionAmount))));
                return -1.0;
            }
            return amount;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.eco.invalid-amount", "<#FF2424>Invalid amount: <#c0f0ff>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", input)));
            return -1.0;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block4: {
            block3: {
                if (!sender.hasPermission(PERMISSION)) {
                    return List.of();
                }
                completions = new ArrayList<String>();
                if (args.length != 1) break block3;
                String input = args[0].toLowerCase();
                for (String s : List.of("give", "take", "set", "reset")) {
                    if (!s.startsWith(input)) continue;
                    completions.add(s);
                }
                break block4;
            }
            if (args.length != 2) break block4;
            String input = args[1].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(input)) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

