/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.DisposalConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public final class DisposalCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.disposal";
    private final PlayerLanguageManager langManager;
    private final DisposalConfig config;
    private final CommandDataStorage dataStorage;

    public DisposalCommand(PlayerLanguageManager langManager, DisposalConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.disposal.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.disposal.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        String title = this.langManager.getMessageFor(player, "commands.disposal.inventory-title", "<red><bold>Disposal", new LanguageManager.ComponentPlaceholder[0]).toString();
        Inventory disposal = Bukkit.createInventory(null, (int)54, (String)title);
        player.openInventory(disposal);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.disposal.opened", "<green>Disposal opened. Place items here to delete them.", new LanguageManager.ComponentPlaceholder[0]));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "disposal", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "disposal", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "disposal", "last_used", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

