/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.DeathConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class DeathCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.death";
    private final PlayerLanguageManager langManager;
    private final DeathConfig config;
    private final CommandDataStorage dataStorage;

    public DeathCommand(PlayerLanguageManager langManager, DeathConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.death.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.death.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        int deaths = player.getStatistic(Statistic.DEATHS);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.death.count", "<red>You have died <gold>{deaths} <red>times.", LanguageManager.ComponentPlaceholder.of("{deaths}", deaths)));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "death", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "death", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "death", "last_check", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

