/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.CraftingTableConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class CraftingTableCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.craftingtable";
    private final PlayerLanguageManager langManager;
    private final CraftingTableConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public CraftingTableCommand(PlayerLanguageManager langManager, CraftingTableConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.craftingtable.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.craftingtable.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        player.openWorkbench(null, true);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.craftingtable.opened", "<green>Crafting table opened!", new LanguageManager.ComponentPlaceholder[0]));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "craftingtable", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "craftingtable", "usage_count", String.valueOf(count + 1));
        });
        return true;
    }
}

