/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.CondenseConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class CondenseCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.condense";
    private static final Map<Material, Material> CONDENSE_MAP = new HashMap<Material, Material>();
    private final PlayerLanguageManager langManager;
    private final CondenseConfig config;
    private final CommandDataStorage dataStorage;

    public CondenseCommand(PlayerLanguageManager langManager, CondenseConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.condense.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.condense.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        boolean condensedSomething = false;
        int totalBlocksCreated = 0;
        for (Map.Entry<Material, Material> entry : CONDENSE_MAP.entrySet()) {
            Material ingot = entry.getKey();
            Material block = entry.getValue();
            int totalIngots = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != ingot) continue;
                totalIngots += item.getAmount();
                item.setAmount(0);
            }
            if (totalIngots >= 9) {
                condensedSomething = true;
                int blocks = totalIngots / 9;
                int remainder = totalIngots % 9;
                totalBlocksCreated += blocks;
                player.getInventory().addItem(new ItemStack[]{new ItemStack(block, blocks)});
                if (remainder <= 0) continue;
                player.getInventory().addItem(new ItemStack[]{new ItemStack(ingot, remainder)});
                continue;
            }
            if (totalIngots <= 0) continue;
            player.getInventory().addItem(new ItemStack[]{new ItemStack(ingot, totalIngots)});
        }
        if (condensedSomething) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.condense.success", "<green>Condensed items into <gold>{blocks} <green>blocks!", LanguageManager.ComponentPlaceholder.of("{blocks}", totalBlocksCreated)));
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.condense.not-enough", "<yellow>You don't have enough items to condense.", new LanguageManager.ComponentPlaceholder[0]));
        }
        UUID playerId = player.getUniqueId();
        int finalTotalBlocksCreated = totalBlocksCreated;
        this.dataStorage.getState(playerId, "condense", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "condense", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "condense", "blocks_created", String.valueOf(finalTotalBlocksCreated));
        });
        return true;
    }

    static {
        CONDENSE_MAP.put(Material.IRON_INGOT, Material.IRON_BLOCK);
        CONDENSE_MAP.put(Material.GOLD_INGOT, Material.GOLD_BLOCK);
        CONDENSE_MAP.put(Material.DIAMOND, Material.DIAMOND_BLOCK);
        CONDENSE_MAP.put(Material.EMERALD, Material.EMERALD_BLOCK);
        CONDENSE_MAP.put(Material.REDSTONE, Material.REDSTONE_BLOCK);
        CONDENSE_MAP.put(Material.LAPIS_LAZULI, Material.LAPIS_BLOCK);
        CONDENSE_MAP.put(Material.COAL, Material.COAL_BLOCK);
        CONDENSE_MAP.put(Material.NETHERITE_INGOT, Material.NETHERITE_BLOCK);
        CONDENSE_MAP.put(Material.COPPER_INGOT, Material.COPPER_BLOCK);
    }
}

