/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.godlycow.org.commands.config.CoinFlipConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class CoinFlipCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.coinflip";
    private static final String COMMAND_NAME = "coinflip";
    private static final List<String> SUGGESTED_AMOUNTS = Arrays.asList("10", "50", "100", "500", "1000");
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final CoinFlipConfig config;
    private final EconomyManager economyManager;
    private final Random random;

    public CoinFlipCommand(JavaPlugin plugin, PlayerLanguageManager langManager, CoinFlipConfig config, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
        this.random = new Random();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getComponent(null, "commands.coinflip.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.disabled", "<red>\u2717 Coin flip is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            this.plugin.getLogger().warning("Coin flip attempted but economy system is disabled!");
            return true;
        }
        if (args.length != 1) {
            this.sendUsageMessage(player, label);
            return true;
        }
        double amount = this.parseAmount(args[0], player);
        if (amount < 0.0) {
            return true;
        }
        if (amount < this.config.minBetAmount) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.bet-too-low", "<red>Bet too low! Minimum is <yellow>{min}", LanguageManager.ComponentPlaceholder.of("{min}", this.economyManager.format(this.config.minBetAmount))));
            return true;
        }
        if (amount > this.config.maxBetAmount) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.bet-too-high", "<red>Bet too high! Maximum is <yellow>{max}", LanguageManager.ComponentPlaceholder.of("{max}", this.economyManager.format(this.config.maxBetAmount))));
            return true;
        }
        double balance = this.economyManager.getBalance(player);
        if (balance < amount) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.not-enough", "<red>You don't have enough money! You need <yellow>{needed}</yellow>, you have <green>{balance}", LanguageManager.ComponentPlaceholder.of("{needed}", this.economyManager.format(amount)), LanguageManager.ComponentPlaceholder.of("{balance}", this.economyManager.format(balance))));
            return true;
        }
        boolean win = this.random.nextDouble() < this.config.winChance;
        this.processCoinFlip(player, amount, win);
        return true;
    }

    private void sendUsageMessage(Player player, String label) {
        Component message = this.langManager.getComponent(String.valueOf(player), "commands.coinflip.usage", "<yellow>Usage: <white>{usage}\n<gray>Bet between <green>{min}</green> and <gold>{max}", LanguageManager.ComponentPlaceholder.of("{usage}", "/" + label + " <amount>"), LanguageManager.ComponentPlaceholder.of("{min}", this.economyManager.format(this.config.minBetAmount)), LanguageManager.ComponentPlaceholder.of("{max}", this.economyManager.format(this.config.maxBetAmount)));
        player.sendMessage(message);
    }

    private double parseAmount(String input, Player player) {
        try {
            double amount = Double.parseDouble(input);
            if (amount <= 0.0) {
                player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.positive-amount", "<red>Amount must be positive!", new LanguageManager.ComponentPlaceholder[0]));
                return -1.0;
            }
            return amount;
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.invalid-amount", "<red>Invalid amount: <white>{amount}", LanguageManager.ComponentPlaceholder.of("{amount}", input)));
            return -1.0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processCoinFlip(Player player, double amount, boolean win) {
        if (win) {
            response = this.economyManager.deposit(player, amount);
            if (!response.success()) {
                this.sendTransactionFailedMessage(player, response.errorMessage);
                return;
            }
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.win", "<green><bold>\u2713 YOU WIN!</bold>\n<green>You won <gold>{symbol}{amount}", LanguageManager.ComponentPlaceholder.of("{symbol}", this.getCurrencySymbol()), LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
        } else {
            response = this.economyManager.withdraw(player, amount);
            if (!response.success()) {
                this.sendTransactionFailedMessage(player, response.errorMessage);
                return;
            }
            player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.lose", "<red><bold>\u2717 YOU LOSE!</bold>\n<red>You lost <gold>{symbol}{amount}", LanguageManager.ComponentPlaceholder.of("{symbol}", this.getCurrencySymbol()), LanguageManager.ComponentPlaceholder.of("{amount}", this.economyManager.format(amount))));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 0.8f);
        }
        if (this.config.logFlips) {
            String result = win ? "WON" : "LOST";
            this.plugin.getLogger().info(String.format("[CoinFlip] %s %s %.2f (%s economy)", player.getName(), result, amount, this.economyManager.getEconomyName()));
        }
    }

    private void sendTransactionFailedMessage(Player player, String errorMessage) {
        player.sendMessage(this.langManager.getComponent(String.valueOf(player), "commands.coinflip.transaction-failed", "<red>\u2717 Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", errorMessage)));
        this.plugin.getLogger().warning(String.format("[CoinFlip] Transaction failed for %s: %s", player.getName(), errorMessage));
    }

    private String getCurrencySymbol() {
        String formatted = this.economyManager.format(1.0);
        return formatted.replaceAll("[0-9.,]", "");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission(PERMISSION)) {
            return List.of();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            for (String amount : SUGGESTED_AMOUNTS) {
                if (!amount.startsWith(input)) continue;
                completions.add(amount);
            }
            if (sender instanceof Player) {
                double balance;
                String balanceStr;
                Player player = (Player)sender;
                if (input.isEmpty() && !SUGGESTED_AMOUNTS.contains(balanceStr = String.valueOf((int)(balance = this.economyManager.getBalance(player))))) {
                    completions.add(balanceStr);
                }
            }
        }
        return completions;
    }
}

