/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.regex.Pattern;
import net.godlycow.org.commands.config.ChatFilterConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public final class ChatFilterCommand
implements Listener {
    private static final String BYPASS_PERM = "essc.command.chatfilter.bypass";
    private static final String SEE_BAD_PERM = "essc.command.chatfilter.see-bad-words";
    private final ChatFilterConfig config;
    private final Plugin plugin;
    private final PlayerLanguageManager lang;

    public ChatFilterCommand(Plugin plugin, ChatFilterConfig config, PlayerLanguageManager lang) {
        this.plugin = plugin;
        this.config = config;
        this.lang = lang;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        if (e.getPlayer().hasPermission(BYPASS_PERM)) {
            return;
        }
        String msg = e.getMessage();
        for (String word : this.config.blacklist) {
            if (!Pattern.compile(Pattern.quote(word), 2).matcher(msg).find()) continue;
            e.setCancelled(true);
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                Component formatted = this.lang.getMessageFor(null, "chatfilter.staff Notice", "<gray>[Filter] <white>{player}: {message}", LanguageManager.ComponentPlaceholder.of("{player}", e.getPlayer().getName()), LanguageManager.ComponentPlaceholder.of("{message}", msg));
                Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission(SEE_BAD_PERM)).forEach(p -> p.sendMessage(formatted));
            });
            e.getPlayer().sendMessage(this.lang.getMessageFor(e.getPlayer(), "chatfilter.blocked", "<red>Your message contained inappropriate language.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
    }
}

