/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.BroadcastWorldConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BroadcastWorldCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.broadcastworld";
    private final PlayerLanguageManager langManager;
    private final BroadcastWorldConfig config;

    public BroadcastWorldCommand(PlayerLanguageManager langManager, BroadcastWorldConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.broadcastworld.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.broadcastworld.usage", "<red>Usage: /broadcastworld <world> <message>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        World world = Bukkit.getWorld((String)args[0]);
        if (world == null) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.broadcastworld.world-not-found", "<red>World <yellow>{world}</yellow> not found!", LanguageManager.ComponentPlaceholder.of("{world}", args[0])));
            return true;
        }
        StringBuilder message = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            message.append(args[i]).append(" ");
        }
        String finalMessage = message.toString().trim();
        Component broadcastMessage = this.langManager.getMessageFor(null, "commands.broadcastworld.broadcast", "{message}", LanguageManager.ComponentPlaceholder.of("{message}", finalMessage));
        world.getPlayers().forEach(p -> p.sendMessage(broadcastMessage));
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.broadcastworld.message-sent", "<green>Message broadcasted to world <yellow>{world}</yellow>!", LanguageManager.ComponentPlaceholder.of("{world}", world.getName())));
        return true;
    }
}

