/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.BalanceTopConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BalanceTopCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.balancetop";
    private final PlayerLanguageManager langManager;
    private final BalanceTopConfig config;
    private final EconomyManager economyManager;
    private final EssC plugin;

    public BalanceTopCommand(EssC plugin, PlayerLanguageManager langManager, BalanceTopConfig config, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.no-permission", "<#B22222>You need permission <#a3ff00>{permission}</#a3ff00>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.no-economy", "<#B22222>Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (this.economyManager.getEconomy() == null) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.no-economy", "<#B22222>Economy provider is null. Please check your economy plugin.", new LanguageManager.ComponentPlaceholder[0]));
            this.plugin.getLogger().warning("Economy manager is enabled but economy provider is null!");
            return true;
        }
        int limit = this.config.getLimit();
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.loading", "<gray>Loading top balances...", new LanguageManager.ComponentPlaceholder[0]));
        CompletableFuture.runAsync(() -> {
            try {
                List balances = Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> p.hasPlayedBefore() || p.isOnline()).map(p -> {
                    try {
                        double balance = this.economyManager.getEconomy().getBalance((OfflinePlayer)p);
                        return new PlayerBalance(p.getUniqueId(), p.getName(), balance);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.WARNING, "Failed to get balance for " + p.getName(), e);
                        return null;
                    }
                }).filter(Objects::nonNull).sorted(Comparator.comparingDouble(PlayerBalance::balance).reversed()).limit(limit).collect(Collectors.toList());
                if (balances.isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.no-data", "<yellow>No player data found.", new LanguageManager.ComponentPlaceholder[0])));
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        this.sendTopList(sender, player, balances, limit);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to send top list", e);
                        sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.error", "<red>An error occurred while displaying the top list.", new LanguageManager.ComponentPlaceholder[0]));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to fetch balance top data", e);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.error", "<red>An error occurred: {error}", LanguageManager.ComponentPlaceholder.of("{error}", e.getMessage()))));
            }
        }).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "Balance top command failed", (Throwable)ex);
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.error", "<red>Command failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", ex.getMessage())));
            return null;
        });
        return true;
    }

    private void sendTopList(CommandSender sender, Player player, List<PlayerBalance> balances, int limit) {
        try {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.header", "<#a3ff00>=== Top {limit} Richest Players ===", LanguageManager.ComponentPlaceholder.of("{limit}", String.valueOf(limit))));
            for (int i = 0; i < balances.size(); ++i) {
                PlayerBalance pb = balances.get(i);
                String playerName = pb.name() != null ? pb.name() : "Unknown";
                sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.entry", "<#a3ff00>#{rank} <white>{player} <#708090>- <#a3ff00>{balance}", LanguageManager.ComponentPlaceholder.of("{rank}", String.valueOf(i + 1)), LanguageManager.ComponentPlaceholder.of("{player}", playerName), LanguageManager.ComponentPlaceholder.of("{balance}", this.economyManager.format(pb.balance()))));
            }
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.balancetop.footer", "<#a3ff00>=========================", new LanguageManager.ComponentPlaceholder[0]));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error sending top list", e);
            throw new RuntimeException(e);
        }
    }

    private record PlayerBalance(UUID uuid, String name, double balance) {
    }
}

