/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.godlycow.org.back.BackManager;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.BackConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BackCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.back";
    private static final String PERMISSION_LOBBY = "essc.command.back.lobby";
    private static final String PERMISSION_DEATH = "essc.command.back.death";
    private final PlayerLanguageManager langManager;
    private final BackConfig config;
    private final BackManager backManager;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public BackCommand(PlayerLanguageManager langManager, BackConfig config, BackManager backManager, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.backManager = backManager;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.back.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.back.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            this.teleportToBack(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "lobby": {
                if (!player.hasPermission(PERMISSION_LOBBY)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.back.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_LOBBY)));
                    return true;
                }
                this.teleportToLobby(player);
                break;
            }
            case "death": {
                if (!player.hasPermission(PERMISSION_DEATH)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.back.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_DEATH)));
                    return true;
                }
                this.teleportToDeath(player);
                break;
            }
            default: {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.back.unknown-usage", "<red>Unknown subcommand. Use: <white>/back, /back lobby, /back death", new LanguageManager.ComponentPlaceholder[0]));
            }
        }
        return true;
    }

    private void teleportToBack(Player player) {
        UUID uuid = player.getUniqueId();
        this.backManager.hasBack(uuid).thenAccept(has -> {
            if (!has.booleanValue()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.back.no-back", "<red>No previous location saved.", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            this.backManager.getLastLocation(uuid).thenAccept(location -> {
                if (location == null) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.back.invalid-back", "<red>Your last location is invalid.", new LanguageManager.ComponentPlaceholder[0]));
                    return;
                }
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    player.teleport(location);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.back.teleported-back", "<green>Teleported back to your previous location.", new LanguageManager.ComponentPlaceholder[0]));
                    this.backManager.clearBack(uuid);
                    this.trackUsage(uuid, "back");
                });
            });
        });
    }

    private void teleportToLobby(Player player) {
        World world = Bukkit.getWorld((String)this.config.lobbyWorld());
        if (world == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.back.lobby-not-set", "<red>Lobby location not set or world is unloaded.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        Location lobby = new Location(world, this.config.lobbyX(), this.config.lobbyY(), this.config.lobbyZ(), this.config.lobbyYaw(), this.config.lobbyPitch());
        player.teleport(lobby);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.back.teleported-lobby", "<green>Teleported to the lobby.", new LanguageManager.ComponentPlaceholder[0]));
        this.trackUsage(player.getUniqueId(), "lobby");
    }

    private void teleportToDeath(Player player) {
        Location deathLocation = player.getLastDeathLocation();
        if (deathLocation == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.back.no-death-location", "<red>No death location found.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        player.teleport(deathLocation);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.back.teleported-death", "<green>Teleported to your last death location.", new LanguageManager.ComponentPlaceholder[0]));
        this.trackUsage(player.getUniqueId(), "death");
    }

    private void trackUsage(UUID playerId, String type) {
        this.dataStorage.getState(playerId, "back", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "back", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "back", "last_type", type);
            this.dataStorage.setState(playerId, "back", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        String partial = args[0].toLowerCase();
        if (player.hasPermission(PERMISSION_LOBBY) && "lobby".startsWith(partial)) {
            completions.add("lobby");
        }
        if (player.hasPermission(PERMISSION_DEATH) && "death".startsWith(partial)) {
            completions.add("death");
        }
        if (player.hasPermission(PERMISSION) && "back".startsWith(partial)) {
            completions.add("back");
        }
        return completions;
    }
}

