/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.List;
import java.util.logging.Level;
import net.godlycow.org.auction.gui.AuctionGUIListener;
import net.godlycow.org.auction.model.AuctionItem;
import net.godlycow.org.auction.storage.AuctionStorage;
import net.godlycow.org.commands.config.AuctionConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class AuctionCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION_BASE = "essc.command.auction";
    private static final String PERMISSION_USE = "essc.command.auction.use";
    private static final String PERMISSION_SELL = "essc.command.auction.sell";
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final AuctionConfig config;
    private final AuctionStorage storage;
    private final AuctionGUIListener guiListener;
    private final EconomyManager economyManager;

    public AuctionCommand(Plugin plugin, PlayerLanguageManager langManager, AuctionConfig config, AuctionStorage storage, AuctionGUIListener guiListener, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
        this.guiListener = guiListener;
        this.economyManager = economyManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            if (sender instanceof ConsoleCommandSender) {
                this.plugin.getLogger().log(Level.INFO, this.langManager.getMessageFor(null, "commands.auction.only-player", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]).toString());
            } else {
                sender.sendMessage(this.langManager.getMessageFor(null, "commands.auction.only-player", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]));
            }
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_BASE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_BASE)));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 0) {
            if (!player.hasPermission(PERMISSION_USE)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_USE)));
                return true;
            }
            this.guiListener.openAuctionGUI(player, 1);
            return true;
        }
        String subcommand = args[0].toLowerCase();
        if (subcommand.equals("sell")) {
            this.handleSell(player, args);
            return true;
        }
        if (subcommand.equals("my")) {
            if (!player.hasPermission(PERMISSION_USE)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_USE)));
                return true;
            }
            this.guiListener.openPlayerItemsGUI(player, 1);
            return true;
        }
        this.showUsage(player);
        return true;
    }

    private void handleSell(Player player, String[] args) {
        double price;
        if (!player.hasPermission(PERMISSION_SELL)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_SELL)));
            return;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem == null || handItem.getType().isAir()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.sell.no-item", "<red>You must hold an item in your hand to sell!", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        if (args.length < 2) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.sell.usage", "<red>Usage: /auction sell <price>", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        try {
            price = Double.parseDouble(args[1]);
            if (price <= 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.sell.invalid-price", "<red>Invalid price! Must be a positive number.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        if (handItem.getAmount() > this.config.maxSellLimit) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.sell.max-limit", "<red>You can only sell up to <yellow>{max}</yellow> items at once!", LanguageManager.ComponentPlaceholder.of("{max}", this.config.maxSellLimit)));
            return;
        }
        long expirationTime = System.currentTimeMillis() + (long)this.config.expirationDays * 24L * 60L * 60L * 1000L;
        ItemStack itemToSell = handItem.clone();
        player.getInventory().setItemInMainHand(null);
        AuctionItem auctionItem = new AuctionItem(player.getUniqueId(), itemToSell, price, expirationTime);
        this.storage.addItem(auctionItem).thenAccept(v -> player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.sell.success", "<green>Item listed for <red>${price}</red>!", LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(price)))));
    }

    private void showUsage(Player player) {
        player.sendMessage(this.langManager.getMessageFor(player, "commands.auction.usage", "<yellow>Usage:</yellow> /auction [sell <price>|my]", new LanguageManager.ComponentPlaceholder[0]));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_BASE)) {
            return List.of();
        }
        if (args.length == 1) {
            return List.of("sell", "my").stream().filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        return List.of();
    }
}

