/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import net.godlycow.org.commands.config.AltsConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class AltsCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.alts";
    private final PlayerLanguageManager langManager;
    private final AltsConfig config;

    public AltsCommand(PlayerLanguageManager langManager, AltsConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player playerSender;
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.alts.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.alts.usage", "<red>Usage: /alts <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.alts.player-offline", "<red>Player must be online to check their IP.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        InetAddress targetIP = target.getAddress().getAddress();
        ArrayList<String> matchedPlayers = new ArrayList<String>();
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (player2.equals((Object)target) || !player2.getAddress().getAddress().equals(targetIP)) continue;
            matchedPlayers.add(player2.getName());
        }
        sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.alts.header", "<yellow>Players with the same IP as {target}:", LanguageManager.ComponentPlaceholder.of("{target}", target.getName())));
        if (matchedPlayers.isEmpty()) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.alts.none", "<gray>- None found online.", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            for (String name : matchedPlayers) {
                sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.alts.found", "<gray>- {player}", LanguageManager.ComponentPlaceholder.of("{player}", name)));
            }
        }
        return true;
    }
}

