/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.afk.AFKManager;
import net.godlycow.org.commands.config.AFKConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class AFKCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.afk";
    private static final String RELOAD_PERMISSION = "essc.command.afk.reload";
    private final PlayerLanguageManager langManager;
    private final AFKConfig config;
    private final AFKManager afkManager;

    public AFKCommand(PlayerLanguageManager langManager, AFKConfig config, AFKManager afkManager) {
        this.langManager = langManager;
        this.config = config;
        this.afkManager = afkManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.config.enabled) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.afk.disabled", "<red>The AFK system is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            return this.handleReload(sender);
        }
        return this.handleAfkToggle(sender);
    }

    private boolean handleReload(CommandSender sender) {
        Player p;
        if (!sender.hasPermission(RELOAD_PERMISSION)) {
            Player p2;
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p2 = (Player)sender) : null, "commands.afk.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", RELOAD_PERMISSION)));
            return true;
        }
        this.config.reload();
        this.afkManager.reload();
        sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p = (Player)sender) : null, "commands.afk.reload", "<green>AFK system reloaded successfully.", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }

    private boolean handleAfkToggle(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.afk.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.afk.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        this.afkManager.toggleAFK(player);
        return true;
    }
}

