/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.time.Duration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WarpConfig {
    private final Plugin plugin;
    public final Duration cooldown;
    public final int defaultMaxWarps;

    public WarpConfig(Plugin plugin) {
        this.plugin = plugin;
        this.cooldown = Duration.ofSeconds(plugin.getConfig().getLong("warp.cooldown", 0L));
        this.defaultMaxWarps = plugin.getConfig().getInt("warp.max-per-player", 10);
    }

    public int getMaxWarpsForPlayer(Player player) {
        if (player.hasPermission("essc.command.setwarp.unlimited")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 100; i >= 1; --i) {
            if (!player.hasPermission("essc.command.setwarp." + i)) continue;
            return i;
        }
        return this.defaultMaxWarps;
    }
}

