/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class SellConfig {
    private final Plugin plugin;
    private final Map<Material, Double> sellPrices = new HashMap<Material, Double>();
    public final String guiTitle;
    public final int guiSize;
    public final boolean enabled;
    public final String currencySymbol;

    public SellConfig(Plugin plugin) {
        this.plugin = plugin;
        this.loadPricesFromShopConfigs();
        FileConfiguration config = plugin.getConfig();
        this.guiTitle = config.getString("sellgui.title", "<gold>\ud83d\udcb0 Sell Items");
        this.guiSize = Math.max(9, Math.min(54, config.getInt("sellgui.size", 45)));
        this.enabled = config.getBoolean("sellgui.enabled", true);
        this.currencySymbol = config.getString("sellgui.currency-symbol", "$");
        if (this.sellPrices.isEmpty()) {
            plugin.getLogger().warning("[SellGUI] No sellable items found! Sell GUI will be non-functional.");
        }
    }

    private void loadPricesFromShopConfigs() {
        File shopFolder = new File(this.plugin.getDataFolder(), "shop");
        if (!shopFolder.exists() || !shopFolder.isDirectory()) {
            this.plugin.getLogger().warning("[SellGUI] Shop folder not found at " + shopFolder.getPath());
            this.plugin.getLogger().warning("[SellGUI] Please ensure shop configs exist with sell-price entries");
            return;
        }
        File[] files = shopFolder.listFiles(f -> f.getName().endsWith(".yml") && !f.getName().equals("main.yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().warning("[SellGUI] No shop config files found in " + shopFolder.getPath());
            return;
        }
        int loadedCount = 0;
        for (File file : files) {
            try {
                ConfigurationSection itemsSection;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                if (!config.contains("items") || (itemsSection = config.getConfigurationSection("items")) == null) continue;
                for (String key : itemsSection.getKeys(false)) {
                    String materialPath = "items." + key + ".material";
                    String sellPricePath = "items." + key + ".sell-price";
                    String matName = config.getString(materialPath);
                    double price = config.getDouble(sellPricePath, -1.0);
                    if (matName == null || !(price > 0.0)) continue;
                    Material mat = Material.matchMaterial((String)matName.toUpperCase());
                    if (mat != null) {
                        this.sellPrices.put(mat, price);
                        ++loadedCount;
                        continue;
                    }
                    this.plugin.getLogger().warning("[SellGUI] Invalid material '" + matName + "' in " + file.getName());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "[SellGUI] Error loading " + file.getName() + ": " + e.getMessage(), e);
            }
        }
        this.plugin.getLogger().info("[SellGUI] Successfully loaded " + loadedCount + " prices from " + files.length + " files");
    }

    public boolean isSellable(Material material) {
        return this.sellPrices.containsKey(material) && this.sellPrices.get(material) > 0.0;
    }

    public Map<Material, Double> getSellPrices() {
        return Map.copyOf(this.sellPrices);
    }

    public double getSellPrice(Material material) {
        return this.sellPrices.getOrDefault(material, 0.0);
    }

    public int getSellableMaterialsCount() {
        return this.sellPrices.size();
    }
}

