/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.godlycow.org.scoreboard.storage.ScoreboardStorage;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ScoreboardConfig {
    public final boolean enabled;
    public final int updateInterval;
    public final String defaultLayout;
    public final Map<String, Layout> layouts = new HashMap<String, Layout>();
    public final Map<String, WorldSetting> worldSettings = new HashMap<String, WorldSetting>();

    public ScoreboardConfig(Plugin plugin) {
        ConfigurationSection config = plugin.getConfig().getConfigurationSection("scoreboard");
        if (config == null) {
            plugin.getLogger().warning("Missing 'scoreboard' section in config.yml, using defaults");
            this.enabled = true;
            this.updateInterval = 20;
            this.defaultLayout = "default";
            return;
        }
        this.enabled = config.getBoolean("enabled", true);
        this.updateInterval = Math.max(1, config.getInt("update-interval", 20));
        this.defaultLayout = config.getString("default-layout", "default");
        this.loadLayouts(config.getConfigurationSection("layouts"), plugin);
        this.loadWorldSettings(config.getConfigurationSection("world-settings"), plugin);
    }

    private void loadLayouts(ConfigurationSection section, Plugin plugin) {
        if (section == null) {
            plugin.getLogger().warning("No layouts defined, using empty default");
            this.layouts.put("default", new Layout("<red>Scoreboard", List.of(), 15));
            return;
        }
        for (String name : section.getKeys(false)) {
            ConfigurationSection layoutSec = section.getConfigurationSection(name);
            if (layoutSec == null) continue;
            String title = layoutSec.getString("title", "<red>Scoreboard");
            List lines = layoutSec.getStringList("lines");
            int maxLines = layoutSec.getInt("max-lines", 15);
            if (lines.isEmpty()) {
                plugin.getLogger().warning("Layout '" + name + "' has no lines defined");
            }
            this.layouts.put(name, new Layout(title, lines, Math.min(maxLines, 15)));
        }
        if (!this.layouts.containsKey(this.defaultLayout)) {
            plugin.getLogger().warning("Default layout '" + this.defaultLayout + "' not found, creating empty");
            this.layouts.put(this.defaultLayout, new Layout("<red>Scoreboard", List.of(), 15));
        }
    }

    private void loadWorldSettings(ConfigurationSection section, Plugin plugin) {
        if (section == null) {
            return;
        }
        for (String world : section.getKeys(false)) {
            ConfigurationSection worldSec = section.getConfigurationSection(world);
            if (worldSec == null) continue;
            boolean enabled = worldSec.getBoolean("enabled", true);
            String layout = worldSec.getString("layout");
            this.worldSettings.put(world, new WorldSetting(enabled, layout));
            plugin.getLogger().fine("Loaded scoreboard setting for world: " + world);
        }
    }

    public Set<String> getLayoutNames() {
        return this.layouts.keySet();
    }

    public boolean layoutExists(String name) {
        return this.layouts.containsKey(name);
    }

    public Layout getLayout(String name) {
        return this.layouts.getOrDefault(name, this.layouts.get(this.defaultLayout));
    }

    public WorldSetting getWorldSetting(String world) {
        return this.worldSettings.get(world);
    }

    public boolean isWorldEnabled(String world) {
        WorldSetting setting = this.getWorldSetting(world);
        return setting == null || setting.enabled();
    }

    public String getWorldLayout(String world) {
        WorldSetting setting = this.getWorldSetting(world);
        return setting != null ? setting.layout() : null;
    }

    public String getLayoutForPlayer(Player player, ScoreboardStorage storage) {
        UUID uuid = player.getUniqueId();
        String savedLayout = storage.getLayout(uuid);
        if (savedLayout != null && this.layoutExists(savedLayout)) {
            return savedLayout;
        }
        String worldLayout = this.getWorldLayout(player.getWorld().getName());
        if (worldLayout != null && this.layoutExists(worldLayout)) {
            return worldLayout;
        }
        return this.defaultLayout;
    }

    public record Layout(String title, List<String> lines, int maxLines) {
    }

    public record WorldSetting(boolean enabled, String layout) {
    }
}

