/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public final class PowerToolConfig {
    private final int maxUses;
    private final Set<Material> allowedMaterials;

    public PowerToolConfig(Plugin plugin) {
        this.maxUses = plugin.getConfig().getInt("powertool.max-uses", 100);
        this.allowedMaterials = new HashSet<Material>();
        for (String matName : plugin.getConfig().getStringList("powertool.allowed-materials")) {
            Material mat = Material.matchMaterial((String)matName.toUpperCase());
            if (mat != null) {
                this.allowedMaterials.add(mat);
                continue;
            }
            plugin.getLogger().warning("Invalid material in powertool.allowed-materials: " + matName);
        }
        if (this.allowedMaterials.isEmpty()) {
            this.addDefaultMaterials();
        }
    }

    private void addDefaultMaterials() {
        this.allowedMaterials.add(Material.STICK);
        this.allowedMaterials.add(Material.BLAZE_ROD);
        this.allowedMaterials.add(Material.BONE);
        this.allowedMaterials.add(Material.ENDER_PEARL);
        this.allowedMaterials.add(Material.EXPERIENCE_BOTTLE);
        this.allowedMaterials.add(Material.CLOCK);
        this.allowedMaterials.add(Material.COMPASS);
    }

    public int maxUses() {
        return this.maxUses;
    }

    public boolean isAllowedMaterial(Material material) {
        return this.allowedMaterials.contains(material);
    }
}

