/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.util.List;
import org.bukkit.plugin.Plugin;

public final class NickConfig {
    public static final String PERMISSION = "essc.command.nick";
    public static final String ADMIN_PERMISSION = "essc.command.nicks";
    public boolean enabled;
    public int minLength;
    public int maxLength;
    public boolean allowFormatting;
    public boolean allowReset;
    public boolean allowDuplicates;
    public int cooldown;
    public int maxChangesPerDay;
    public List<String> blockedWords;
    public List<String> blacklistPatterns;
    private final Plugin plugin;

    public NickConfig(Plugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.enabled = this.plugin.getConfig().getBoolean("nick.enabled", true);
        this.minLength = this.plugin.getConfig().getInt("nick.min-length", 3);
        this.maxLength = this.plugin.getConfig().getInt("nick.max-length", 16);
        this.allowFormatting = this.plugin.getConfig().getBoolean("nick.allow-formatting", true);
        this.allowReset = this.plugin.getConfig().getBoolean("nick.allow-reset", true);
        this.allowDuplicates = this.plugin.getConfig().getBoolean("nick.allow-duplicates", false);
        this.cooldown = this.plugin.getConfig().getInt("nick.cooldown", 60);
        this.maxChangesPerDay = this.plugin.getConfig().getInt("nick.max-changes-per-day", 3);
        this.blockedWords = this.plugin.getConfig().getStringList("nick.blocked-words");
        this.blacklistPatterns = this.plugin.getConfig().getStringList("nick.blacklist-patterns");
    }
}

