/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.time.Duration;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.plugin.Plugin;

public final class LobbyConfig {
    public final Plugin plugin;
    private Duration cooldown;
    private boolean animationEnabled;
    private AnimationOptions animation;
    private boolean perWorld;
    private boolean teleportOnJoin;

    public LobbyConfig(Plugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.cooldown = Duration.ofSeconds(this.plugin.getConfig().getLong("lobby.cooldown", 5L));
        this.animationEnabled = this.plugin.getConfig().getBoolean("lobby.animation.enabled", true);
        if (this.animation == null) {
            this.animation = new AnimationOptions(this.plugin);
        } else {
            this.animation.reload(this.plugin);
        }
        this.perWorld = this.plugin.getConfig().getBoolean("lobby.per-world", false);
        this.teleportOnJoin = this.plugin.getConfig().getBoolean("lobby.teleport-on-join", false);
    }

    public Duration getCooldown() {
        return this.cooldown;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public AnimationOptions getAnimation() {
        return this.animation;
    }

    public boolean isPerWorld() {
        return this.perWorld;
    }

    public boolean isTeleportOnJoin() {
        return this.teleportOnJoin;
    }

    public static class AnimationOptions {
        public String type;
        public int duration;
        public Particle particle;
        public Sound sound;
        public int particleCount;

        public AnimationOptions(Plugin plugin) {
            this.reload(plugin);
        }

        public void reload(Plugin plugin) {
            this.type = plugin.getConfig().getString("lobby.animation.type", "FADE");
            this.duration = plugin.getConfig().getInt("lobby.animation.duration", 40);
            String particleName = plugin.getConfig().getString("lobby.animation.particle", "PORTAL");
            this.particle = Particle.valueOf((String)particleName);
            String soundName = plugin.getConfig().getString("lobby.animation.sound", "ENTITY_ENDERMAN_TELEPORT");
            this.sound = Sound.valueOf((String)soundName);
            this.particleCount = plugin.getConfig().getInt("lobby.animation.particle-count", 50);
        }
    }
}

