/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class KitConfig {
    private final Plugin plugin;
    private String guiTitle;
    private int guiSize;
    private String previewTitle;
    private Material claimButtonMaterial;
    private Material cooldownButtonMaterial;
    private Material backButtonMaterial;

    public KitConfig(Plugin plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        FileConfiguration config = this.plugin.getConfig();
        this.guiTitle = config.getString("kits.gui.title", "<bold><green>Available Kits");
        this.guiSize = config.getInt("kits.gui.size", 54);
        this.previewTitle = config.getString("kits.gui.preview-title", "<white>Preview Kit: <yellow>{kit}");
        this.claimButtonMaterial = Material.valueOf((String)config.getString("kits.gui.buttons.claim.material", "LIME_CONCRETE").toUpperCase());
        this.cooldownButtonMaterial = Material.valueOf((String)config.getString("kits.gui.buttons.cooldown.material", "RED_CONCRETE").toUpperCase());
        this.backButtonMaterial = Material.valueOf((String)config.getString("kits.gui.buttons.back.material", "BARRIER").toUpperCase());
    }

    public String getGuiTitle() {
        return this.guiTitle;
    }

    public int getGuiSize() {
        return this.guiSize;
    }

    public String getPreviewTitle() {
        return this.previewTitle;
    }

    public Material getClaimButtonMaterial() {
        return this.claimButtonMaterial;
    }

    public Material getCooldownButtonMaterial() {
        return this.cooldownButtonMaterial;
    }

    public Material getBackButtonMaterial() {
        return this.backButtonMaterial;
    }
}

