/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.util.List;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class HomesConfig {
    private final Plugin plugin;
    public int maxHomes;
    public boolean allowRename;
    public int setCooldownSeconds;
    public int teleportCooldownSeconds;
    public List<String> disabledWorlds;
    public int maxHomeNameLength;
    public boolean allowDuplicateHomeNames;
    public boolean requireEmptyInventoryToSet;
    public boolean allowCrossWorldTeleport;
    public List<String> restrictedWorldTeleports;

    public HomesConfig(Plugin plugin) {
        this.plugin = plugin;
        this.load();
    }

    private void load() {
        try {
            this.maxHomes = Math.max(1, this.plugin.getConfig().getInt("homes.max-homes", 8));
            this.allowRename = this.plugin.getConfig().getBoolean("homes.allow-rename", true);
            this.setCooldownSeconds = Math.max(0, this.plugin.getConfig().getInt("homes.cooldowns.set", 30));
            this.teleportCooldownSeconds = Math.max(0, this.plugin.getConfig().getInt("homes.cooldowns.teleport", 5));
            this.disabledWorlds = this.plugin.getConfig().getStringList("homes.restrictions.disabled-worlds");
            this.restrictedWorldTeleports = this.plugin.getConfig().getStringList("homes.restrictions.teleport-restricted-worlds");
            this.allowCrossWorldTeleport = this.plugin.getConfig().getBoolean("homes.restrictions.allow-cross-world-teleport", true);
            this.maxHomeNameLength = Math.max(1, Math.min(50, this.plugin.getConfig().getInt("homes.naming.max-length", 20)));
            this.allowDuplicateHomeNames = this.plugin.getConfig().getBoolean("homes.naming.allow-duplicate-names", true);
            this.requireEmptyInventoryToSet = this.plugin.getConfig().getBoolean("homes.restrictions.require-empty-inventory", false);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load homes config", e);
        }
    }

    public boolean isWorldDisabled(String worldName) {
        return worldName != null && this.disabledWorlds.stream().anyMatch(disabled -> disabled.equalsIgnoreCase(worldName));
    }

    public boolean isTeleportRestricted(String worldName) {
        return worldName != null && this.restrictedWorldTeleports.stream().anyMatch(restricted -> restricted.equalsIgnoreCase(worldName));
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.load();
        this.plugin.getLogger().info("[ServerEssentials] Homes config reloaded");
    }
}

