/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class AuctionConfig {
    private final Plugin plugin;
    public final boolean enabled;
    public final int guiRows;
    public final int itemsPerPage;
    public final int maxSellLimit;
    public final int expirationDays;
    public final double maxPriceLimit;
    public final int maxItemsPerPlayer;

    public AuctionConfig(Plugin plugin) {
        this.plugin = plugin;
        this.enabled = this.getConfigBoolean("auction.enabled", true);
        this.guiRows = this.getConfigInt("auction.gui.rows", 6);
        this.itemsPerPage = this.getConfigInt("auction.items-per-page", 36);
        this.maxSellLimit = this.getConfigInt("auction.max-sell-limit", 64);
        this.expirationDays = this.getConfigInt("auction.expiration-days", 7);
        this.maxPriceLimit = this.getConfigDouble("auction.max-price-limit", 1000000.0);
        this.maxItemsPerPlayer = this.getConfigInt("auction.max-items-per-player", 10);
        this.validateConfig();
    }

    private boolean getConfigBoolean(String path, boolean defaultValue) {
        if (!this.plugin.getConfig().isSet(path)) {
            this.plugin.getLogger().log(Level.WARNING, "Auction config missing: " + path + ", using default: " + defaultValue);
            return defaultValue;
        }
        return this.plugin.getConfig().getBoolean(path, defaultValue);
    }

    private int getConfigInt(String path, int defaultValue) {
        if (!this.plugin.getConfig().isSet(path)) {
            this.plugin.getLogger().log(Level.WARNING, "Auction config missing: " + path + ", using default: " + defaultValue);
            return defaultValue;
        }
        return this.plugin.getConfig().getInt(path, defaultValue);
    }

    private double getConfigDouble(String path, double defaultValue) {
        if (!this.plugin.getConfig().isSet(path)) {
            this.plugin.getLogger().log(Level.WARNING, "Auction config missing: " + path + ", using default: " + defaultValue);
            return defaultValue;
        }
        return this.plugin.getConfig().getDouble(path, defaultValue);
    }

    private void validateConfig() {
        if (this.guiRows < 1 || this.guiRows > 6) {
            this.plugin.getLogger().log(Level.WARNING, "Invalid auction.gui.rows: " + this.guiRows + ", must be 1-6. Using default 6.");
        }
        if (this.itemsPerPage > (this.guiRows - 1) * 7) {
            this.plugin.getLogger().log(Level.WARNING, "items-per-page (" + this.itemsPerPage + ") exceeds available slots for guiRows (" + this.guiRows + ")");
        }
    }
}

