/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.config;

import java.util.List;
import org.bukkit.plugin.Plugin;

public final class AFKConfig {
    public boolean enabled;
    public long timeoutSeconds;
    public boolean kickOnAFK;
    public boolean teleportOnAFK;
    public String teleportWorld;
    public double teleportX;
    public double teleportY;
    public double teleportZ;
    public boolean soundsEnabled;
    public String soundName;
    public boolean particlesEnabled;
    public String particleName;
    public boolean bossbarEnabled;
    public String bossbarText;
    public String bossbarColor;
    public String bossbarStyle;
    public boolean broadcastEnabled;
    public boolean disableFlight;
    public boolean disableDamage;
    public boolean disableItemPickup;
    public boolean actionBarEnabled;
    public String actionBarText;
    public boolean modifyTablist;
    public String tablistPrefix;
    public String tablistSuffix;
    public List<String> exemptWorlds;
    public String enterMessage;
    public String leaveMessage;
    public String kickMessage;
    private final Plugin plugin;

    public AFKConfig(Plugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.enabled = this.plugin.getConfig().getBoolean("afk.enabled", true);
        this.timeoutSeconds = this.plugin.getConfig().getLong("afk.timeout-seconds", 300L);
        this.kickOnAFK = this.plugin.getConfig().getBoolean("afk.kick-on-afk", false);
        this.teleportOnAFK = this.plugin.getConfig().getBoolean("afk.teleport.enabled", false);
        this.teleportWorld = this.plugin.getConfig().getString("afk.teleport.world", "world");
        this.teleportX = this.plugin.getConfig().getDouble("afk.teleport.x", 0.0);
        this.teleportY = this.plugin.getConfig().getDouble("afk.teleport.y", 64.0);
        this.teleportZ = this.plugin.getConfig().getDouble("afk.teleport.z", 0.0);
        this.soundsEnabled = this.plugin.getConfig().getBoolean("afk.sounds.enabled", true);
        this.soundName = this.plugin.getConfig().getString("afk.sounds.sound", "BLOCK_NOTE_BLOCK_BELL");
        this.particlesEnabled = this.plugin.getConfig().getBoolean("afk.particles.enabled", true);
        this.particleName = this.plugin.getConfig().getString("afk.particles.particle", "CRIT");
        this.bossbarEnabled = this.plugin.getConfig().getBoolean("afk.bossbar.enabled", false);
        this.bossbarText = this.plugin.getConfig().getString("afk.bossbar.text", "<yellow>%player% is AFK");
        this.bossbarColor = this.plugin.getConfig().getString("afk.bossbar.color", "YELLOW");
        this.bossbarStyle = this.plugin.getConfig().getString("afk.bossbar.style", "SEGMENTED_20");
        this.broadcastEnabled = this.plugin.getConfig().getBoolean("afk.broadcast.enabled", true);
        this.disableFlight = this.plugin.getConfig().getBoolean("afk.disable-flight", true);
        this.disableDamage = this.plugin.getConfig().getBoolean("afk.disable-damage", false);
        this.disableItemPickup = this.plugin.getConfig().getBoolean("afk.disable-item-pickup", true);
        this.actionBarEnabled = this.plugin.getConfig().getBoolean("afk.actionbar.enabled", false);
        this.actionBarText = this.plugin.getConfig().getString("afk.actionbar.text", "<gray>%player% is AFK");
        this.modifyTablist = this.plugin.getConfig().getBoolean("afk.modify-tablist", false);
        this.tablistPrefix = this.plugin.getConfig().getString("afk.tablist.prefix", "<yellow>[AFK] ");
        this.tablistSuffix = this.plugin.getConfig().getString("afk.tablist.suffix", "");
        this.exemptWorlds = this.plugin.getConfig().getStringList("afk.exempt-worlds");
        this.enterMessage = this.plugin.getConfig().getString("afk.messages.enter", "<yellow>%player% is now AFK");
        this.leaveMessage = this.plugin.getConfig().getString("afk.messages.leave", "<yellow>%player% is no longer AFK");
        this.kickMessage = this.plugin.getConfig().getString("afk.messages.kick", "<red>You were kicked for being AFK");
    }
}

