/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands;

import java.util.ArrayList;
import java.util.List;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class LanguageCommand
implements CommandExecutor,
TabCompleter {
    private final LanguageManager languageManager;
    private final PlayerLanguageManager playerLanguageManager;

    public LanguageCommand(LanguageManager languageManager, PlayerLanguageManager playerLanguageManager) {
        this.languageManager = languageManager;
        this.playerLanguageManager = playerLanguageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("essc.command.language.reload")) {
                sender.sendMessage("\u00a7cYou don't have permission to reload languages.");
                return true;
            }
            sender.sendMessage("Reloading language files...");
            this.languageManager.reloadLanguages();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.sendMessage(this.playerLanguageManager.getMessageFor(player, "language.reload.complete", "<green>\u2713 Successfully reloaded <white>{count}</white> languages!", LanguageManager.ComponentPlaceholder.of("{count}", String.valueOf(this.languageManager.getAvailableLanguages().size()))));
            } else {
                sender.sendMessage("\u00a7a\u2713 Successfully reloaded " + this.languageManager.getAvailableLanguages().size() + " languages!");
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cUsage: /language reload");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(this.playerLanguageManager.getMessageFor(player, "language.usage", "<yellow>Usage: <white>/language <language></white> or <white>/language reload</white>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String targetLang = args[0].toLowerCase();
        if (!this.languageManager.hasLanguage(targetLang)) {
            player.sendMessage(this.playerLanguageManager.getMessageFor(player, "language.invalid", "<red>\u2717 Invalid language: <white>{lang}</white>", LanguageManager.ComponentPlaceholder.of("{lang}", targetLang)));
            player.sendMessage(this.playerLanguageManager.getMessageFor(player, "language.available", "<yellow>Available languages: <white>{langs}</white>", LanguageManager.ComponentPlaceholder.of("{langs}", String.join((CharSequence)", ", this.languageManager.getAvailableLanguages()))));
            return true;
        }
        this.playerLanguageManager.setPlayerLanguage(player.getUniqueId(), targetLang);
        player.sendMessage(this.playerLanguageManager.getMessageFor(player, "language.changed", "<green>\u2713 Language changed to: <white>{lang}</white>", LanguageManager.ComponentPlaceholder.of("{lang}", targetLang)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("godlycow.language.reload") && "reload".startsWith(input)) {
                completions.add("reload");
            }
            this.languageManager.getAvailableLanguages().stream().filter(lang -> lang.startsWith(input)).forEach(completions::add);
            return completions;
        }
        return List.of();
    }
}

