/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.back.api;

import com.serveressentials.api.back.BackAPI;
import com.serveressentials.api.back.event.BackEvent;
import com.serveressentials.api.back.event.BackLocationSaveEvent;
import com.serveressentials.api.back.event.BackTeleportEvent;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.EssC;
import net.godlycow.org.back.BackManager;
import net.godlycow.org.back.storage.BackDataStorage;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.BackConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackAPIImpl
implements BackAPI {
    private static final String PERMISSION_BACK = "essentialsc.command.back";
    private static final String PERMISSION_LOBBY = "essentialsc.command.back.lobby";
    private static final String PERMISSION_DEATH = "essentialsc.command.back.death";
    @NotNull
    private final EssC plugin;
    @NotNull
    private final BackManager backManager;
    @NotNull
    private final BackConfig config;
    @NotNull
    private final BackDataStorage storage;
    @NotNull
    private final PlayerLanguageManager langManager;
    @NotNull
    private final CommandDataStorage dataStorage;

    public BackAPIImpl(@NotNull EssC plugin, @NotNull BackManager backManager, @NotNull BackConfig config, @NotNull BackDataStorage storage, @NotNull PlayerLanguageManager langManager, @NotNull CommandDataStorage dataStorage) {
        this.plugin = plugin;
        this.backManager = backManager;
        this.config = config;
        this.storage = storage;
        this.langManager = langManager;
        this.dataStorage = dataStorage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportBack(@NotNull Player player) {
        return this.backManager.getLastLocation(player.getUniqueId()).thenCompose(location -> {
            if (location == null) {
                this.sendMessage(player, "commands.back.no-back", "<red>No previous location saved.");
                return CompletableFuture.completedFuture(false);
            }
            return this.performTeleport(player, (Location)location, BackEvent.BackType.BACK_LOCATION).thenApply(success -> {
                if (success.booleanValue()) {
                    this.backManager.clearBack(player.getUniqueId());
                    this.trackUsage(player.getUniqueId(), "back");
                }
                return success;
            });
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportToLobby(@NotNull Player player) {
        if (!player.hasPermission(PERMISSION_LOBBY)) {
            this.sendNoPermissionMessage(player, PERMISSION_LOBBY);
            return CompletableFuture.completedFuture(false);
        }
        Location lobbyLocation = this.getLobbyLocation();
        if (lobbyLocation == null) {
            this.sendMessage(player, "commands.back.lobby-not-set", "<red>Lobby location not set or world is unloaded.");
            return CompletableFuture.completedFuture(false);
        }
        return this.performTeleport(player, lobbyLocation, BackEvent.BackType.LOBBY).thenApply(success -> {
            if (success.booleanValue()) {
                this.trackUsage(player.getUniqueId(), "lobby");
            }
            return success;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportToDeath(@NotNull Player player) {
        if (!player.hasPermission(PERMISSION_DEATH)) {
            this.sendNoPermissionMessage(player, PERMISSION_DEATH);
            return CompletableFuture.completedFuture(false);
        }
        Location deathLocation = player.getLastDeathLocation();
        if (deathLocation == null) {
            this.sendMessage(player, "commands.back.no-death-location", "<red>No death location found.");
            return CompletableFuture.completedFuture(false);
        }
        return this.performTeleport(player, deathLocation, BackEvent.BackType.DEATH_LOCATION).thenApply(success -> {
            if (success.booleanValue()) {
                this.trackUsage(player.getUniqueId(), "death");
            }
            return success;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> setBackLocation(@NotNull Player player, @NotNull Location location) {
        return this.backManager.setLastLocation(player.getUniqueId(), location).thenRun(() -> Bukkit.getPluginManager().callEvent((Event)new BackLocationSaveEvent(player, location)));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Location>> getBackLocation(@NotNull Player player) {
        return this.backManager.getLastLocation(player.getUniqueId()).thenApply(location -> Optional.ofNullable(location));
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> hasBackLocation(@NotNull Player player) {
        return this.backManager.hasBack(player.getUniqueId());
    }

    @Override
    @NotNull
    public CompletableFuture<Void> clearBackLocation(@NotNull Player player) {
        return this.backManager.clearBack(player.getUniqueId());
    }

    @Override
    public boolean isBackEnabled() {
        return this.plugin.getConfig().getBoolean("back.enabled", true);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            Bukkit.getLogger().info("[ServerEssentials] Back configuration reloaded");
        });
    }

    @NotNull
    private CompletableFuture<Boolean> performTeleport(@NotNull Player player, @NotNull Location destination, @NotNull BackEvent.BackType backType) {
        Location from = player.getLocation();
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            player.teleport(destination);
            this.sendMessage(player, "commands.back.teleported-" + backType.name().toLowerCase(), "<green>Teleported successfully.");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                Bukkit.getPluginManager().callEvent((Event)new BackTeleportEvent(player, backType, from, destination));
                result.complete(true);
            });
        });
        return result;
    }

    @Nullable
    private Location getLobbyLocation() {
        World world = Bukkit.getWorld((String)this.config.lobbyWorld());
        if (world == null) {
            return null;
        }
        return new Location(world, this.config.lobbyX(), this.config.lobbyY(), this.config.lobbyZ(), this.config.lobbyYaw(), this.config.lobbyPitch());
    }

    private void sendMessage(@NotNull Player player, @NotNull String key, @NotNull String defaultMsg) {
        player.sendMessage(this.langManager.getMessageFor(player, key, defaultMsg, new LanguageManager.ComponentPlaceholder[0]).toString());
    }

    private void sendNoPermissionMessage(@NotNull Player player, @NotNull String permission) {
        player.sendMessage(this.langManager.getMessageFor(player, "commands.back.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", permission)));
    }

    private void trackUsage(@NotNull UUID playerId, @NotNull String type) {
        this.dataStorage.getState(playerId, "back", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "back", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "back", "last_type", type);
            this.dataStorage.setState(playerId, "back", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

