/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.auction.model;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class AuctionItem {
    private final UUID id;
    private final UUID seller;
    private final ItemStack item;
    private final double price;
    private final long expiration;

    public AuctionItem(UUID seller, ItemStack item, double price, long expiration) {
        this(UUID.randomUUID(), seller, item, price, expiration);
    }

    public AuctionItem(UUID id, UUID seller, ItemStack item, double price, long expiration) {
        this.id = Objects.requireNonNull(id, "ID cannot be null");
        this.seller = Objects.requireNonNull(seller, "Seller cannot be null");
        this.item = Objects.requireNonNull(item, "Item cannot be null");
        if (item.getType().isAir()) {
            throw new IllegalArgumentException("Item cannot be AIR");
        }
        this.price = price;
        if (price <= 0.0) {
            throw new IllegalArgumentException("Price must be positive");
        }
        this.expiration = expiration;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSeller() {
        return this.seller;
    }

    public ItemStack getItem() {
        return this.item.clone();
    }

    public double getPrice() {
        return this.price;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuctionItem that = (AuctionItem)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

