/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.auction.gui;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.godlycow.org.auction.model.AuctionItem;
import net.godlycow.org.auction.storage.AuctionStorage;
import net.godlycow.org.commands.config.AuctionConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AuctionGUIListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final AuctionConfig config;
    private final AuctionStorage storage;
    private final EconomyManager economyManager;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<UUID, Map<Integer, UUID>> auctionViewingMap = new ConcurrentHashMap<UUID, Map<Integer, UUID>>();
    private final Map<UUID, Map<Integer, UUID>> playerItemsViewingMap = new ConcurrentHashMap<UUID, Map<Integer, UUID>>();
    private final Map<UUID, UUID> pendingRemovalMap = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, GUIType> playerGUITypeMap = new ConcurrentHashMap<UUID, GUIType>();
    private final Map<UUID, Integer> playerPageMap = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> clickCooldownMap = new ConcurrentHashMap<UUID, Long>();
    private static final long CLICK_COOLDOWN_MS = 300L;
    private final NamespacedKey guiItemKey;
    private final NamespacedKey guiItemTypeKey;

    public AuctionGUIListener(Plugin plugin, PlayerLanguageManager langManager, AuctionConfig config, AuctionStorage storage, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
        this.economyManager = economyManager;
        this.guiItemKey = new NamespacedKey(plugin, "auction_gui_item");
        this.guiItemTypeKey = new NamespacedKey(plugin, "auction_gui_item_type");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String itemType;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof AuctionGUIHolder)) {
            return;
        }
        AuctionGUIHolder holder = (AuctionGUIHolder)inventoryHolder;
        long currentTime = System.currentTimeMillis();
        Long lastClick = this.clickCooldownMap.get(playerId);
        if (lastClick != null && currentTime - lastClick < 300L) {
            event.setCancelled(true);
            return;
        }
        this.clickCooldownMap.put(playerId, currentTime);
        GUIType guiType = holder.getGuiType();
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType().isAir()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.guiItemKey, PersistentDataType.BYTE) && (itemType = (String)container.get(this.guiItemTypeKey, PersistentDataType.STRING)) != null) {
            try {
                this.handleSpecialItemClick(player, holder, GuiItemType.valueOf(itemType));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, "Invalid GUI item type: " + itemType);
            }
            return;
        }
        int slot = event.getRawSlot();
        switch (guiType.ordinal()) {
            case 2: {
                this.handleConfirmRemovalClick(player, slot);
                break;
            }
            case 1: {
                this.handlePlayerItemClick(player, slot);
                break;
            }
            case 0: {
                this.handleAuctionItemClick(player, slot);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof AuctionGUIHolder) {
            AuctionGUIHolder holder = (AuctionGUIHolder)inventoryHolder;
            if (holder.getGuiType() == GUIType.PLAYER_ITEMS && this.pendingRemovalMap.containsKey(playerId)) {
                return;
            }
            this.cleanupPlayerState(playerId);
        }
    }

    private void cleanupPlayerState(UUID playerId) {
        this.auctionViewingMap.remove(playerId);
        if (!this.isInGUITransition(playerId)) {
            this.playerItemsViewingMap.remove(playerId);
            this.pendingRemovalMap.remove(playerId);
        }
        if (!this.isInGUITransition(playerId)) {
            this.playerGUITypeMap.remove(playerId);
        }
        this.playerPageMap.remove(playerId);
        this.clickCooldownMap.remove(playerId);
    }

    private void handleSpecialItemClick(Player player, AuctionGUIHolder holder, GuiItemType itemType) {
        UUID playerId = player.getUniqueId();
        int currentPage = holder.getPage();
        switch (itemType.ordinal()) {
            case 0: {
                if (currentPage <= 1) break;
                this.openGUIForType(player, holder.getGuiType(), currentPage - 1);
                break;
            }
            case 1: {
                this.openGUIForType(player, holder.getGuiType(), currentPage + 1);
                break;
            }
            case 2: {
                this.openGUIForType(player, holder.getGuiType(), currentPage);
                this.sendTranslatedMessage(player, "commands.auction.gui.refresh", "<green>Auction refreshed!", new LanguageManager.ComponentPlaceholder[0]);
                break;
            }
            case 3: {
                this.openGUIForType(player, GUIType.PLAYER_ITEMS, 1);
                break;
            }
            case 4: {
                player.closeInventory();
                break;
            }
            case 5: {
                double balance = this.economyManager.getBalance(player);
                this.sendTranslatedMessage(player, "commands.auction.gui.balance.message", "<green>Balance: <yellow>${balance}", LanguageManager.ComponentPlaceholder.of("{balance}", this.economyManager.format(balance)));
                break;
            }
            case 6: {
                this.handleConfirmRemoval(player, true);
                break;
            }
            case 7: {
                this.handleConfirmRemoval(player, false);
                break;
            }
        }
    }

    private void handleConfirmRemovalClick(Player player, int slot) {
        boolean confirmed = slot == 11;
        this.handleConfirmRemoval(player, confirmed);
    }

    private void handleConfirmRemoval(Player player, boolean confirmed) {
        UUID playerId = player.getUniqueId();
        UUID itemId = this.pendingRemovalMap.remove(playerId);
        if (itemId == null) {
            this.plugin.getLogger().log(Level.WARNING, "[Auction] No pending removal for " + player.getName());
            this.sendTranslatedMessage(player, "commands.auction.remove.no-pending", "<red>No pending removal found!", new LanguageManager.ComponentPlaceholder[0]);
            player.closeInventory();
            return;
        }
        if (!confirmed) {
            this.sendTranslatedMessage(player, "commands.auction.remove.cancelled", "<gray>Removal cancelled.", new LanguageManager.ComponentPlaceholder[0]);
            this.openPlayerItemsGUI(player, this.getCurrentPage(playerId, GUIType.PLAYER_ITEMS));
            return;
        }
        this.storage.getItemData(itemId).thenAccept(optItem -> {
            if (optItem.isEmpty()) {
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    this.sendTranslatedMessage(player, "commands.auction.remove.not-found", "<red>Item not found!", new LanguageManager.ComponentPlaceholder[0]);
                    this.openPlayerItemsGUI(player, 1);
                });
                return;
            }
            AuctionItem item = (AuctionItem)optItem.get();
            ((CompletableFuture)this.storage.removeItem(itemId).thenRun(() -> Bukkit.getScheduler().runTask(this.plugin, () -> {
                HashMap remaining = player.getInventory().addItem(new ItemStack[]{item.getItem().clone()});
                if (!remaining.isEmpty()) {
                    remaining.values().forEach(drop -> player.getWorld().dropItemNaturally(player.getLocation(), drop));
                    this.sendTranslatedMessage(player, "commands.auction.remove.inventory-full", "<yellow>Item dropped on the ground (inventory full)", new LanguageManager.ComponentPlaceholder[0]);
                }
                this.sendTranslatedMessage(player, "commands.auction.remove.success", "<green>Item removed successfully!", new LanguageManager.ComponentPlaceholder[0]);
                this.openPlayerItemsGUI(player, this.getCurrentPage(playerId, GUIType.PLAYER_ITEMS));
            }))).exceptionally(ex -> {
                this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to remove item", (Throwable)ex);
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    this.sendTranslatedMessage(player, "commands.auction.remove.failed", "<red>Failed to remove item. Please try again.", new LanguageManager.ComponentPlaceholder[0]);
                    this.openPlayerItemsGUI(player, 1);
                });
                return null;
            });
        });
    }

    private void handlePlayerItemClick(Player player, int slot) {
        UUID playerId = player.getUniqueId();
        Map<Integer, UUID> slotMap = this.playerItemsViewingMap.get(playerId);
        if (slotMap == null) {
            this.plugin.getLogger().log(Level.WARNING, "[Auction] No slot map for " + player.getName() + ". This may indicate a state sync issue.");
            this.openPlayerItemsGUI(player, 1);
            return;
        }
        UUID itemId = slotMap.get(slot);
        if (itemId == null) {
            return;
        }
        this.pendingRemovalMap.put(playerId, itemId);
        this.openRemoveConfirmGUI(player);
    }

    private void handleAuctionItemClick(Player player, int slot) {
        UUID playerId = player.getUniqueId();
        Map<Integer, UUID> slotMap = this.auctionViewingMap.get(playerId);
        if (slotMap == null) {
            this.plugin.getLogger().log(Level.WARNING, "[Auction] No auction slot map for " + player.getName());
            return;
        }
        UUID itemId = slotMap.get(slot);
        if (itemId == null) {
            return;
        }
        ((CompletableFuture)this.storage.getItemData(itemId).thenAccept(optItem -> {
            if (optItem.isEmpty()) {
                Bukkit.getScheduler().runTask(this.plugin, () -> this.sendTranslatedMessage(player, "commands.auction.purchase.not-found", "<red>Item no longer available!", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            Bukkit.getScheduler().runTask(this.plugin, () -> this.processPurchase(player, (AuctionItem)optItem.get()));
        })).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to get item data", (Throwable)ex);
            return null;
        });
    }

    private void processPurchase(Player player, AuctionItem item) {
        if (!this.economyManager.isEnabled()) {
            this.sendTranslatedMessage(player, "commands.auction.purchase.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]);
            return;
        }
        double balance = this.economyManager.getBalance(player);
        if (balance < item.getPrice()) {
            this.sendTranslatedMessage(player, "commands.auction.purchase.not-enough-money", "<red>You don't have enough money!", new LanguageManager.ComponentPlaceholder[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            EconomyResponse withdrawResponse = this.economyManager.withdraw(player, item.getPrice());
            if (!withdrawResponse.success()) {
                Bukkit.getScheduler().runTask(this.plugin, () -> this.sendTranslatedMessage(player, "commands.auction.purchase.failed", "<red>Transaction failed: " + withdrawResponse.errorMessage, new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            Player sellerPlayer = Bukkit.getPlayer((UUID)item.getSeller());
            if (sellerPlayer != null && sellerPlayer.isOnline()) {
                EconomyResponse depositResponse = this.economyManager.deposit(sellerPlayer, item.getPrice());
                if (!depositResponse.success()) {
                    this.economyManager.deposit(player, item.getPrice());
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.sendTranslatedMessage(player, "commands.auction.purchase.failed", "<red>Transaction failed: Could not pay seller", new LanguageManager.ComponentPlaceholder[0]));
                    return;
                }
                this.sendTranslatedMessage(sellerPlayer, "commands.auction.purchase.seller-message", "<green>{buyer} purchased your item for ${price}!", LanguageManager.ComponentPlaceholder.of("{buyer}", player.getName()), LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(item.getPrice())));
            }
            ((CompletableFuture)this.storage.removeItem(item.getId()).thenAccept(v -> Bukkit.getScheduler().runTask(this.plugin, () -> {
                player.getInventory().addItem(new ItemStack[]{item.getItem().clone()});
                this.sendTranslatedMessage(player, "commands.auction.purchase.success", "<green>Purchased for <yellow>${price}</yellow>!", LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(item.getPrice())));
                UUID playerId = player.getUniqueId();
                int currentPage = this.getCurrentPage(playerId, GUIType.AUCTION_HOUSE);
                this.openAuctionGUI(player, currentPage);
            }))).exceptionally(ex -> {
                this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to remove item after purchase", (Throwable)ex);
                Bukkit.getScheduler().runTask(this.plugin, () -> this.sendTranslatedMessage(player, "commands.auction.purchase.failed", "<red>Failed to complete purchase. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
                return null;
            });
        });
    }

    private void openGUIForType(Player player, GUIType guiType, int page) {
        if (!this.economyManager.isEnabled()) {
            this.sendTranslatedMessage(player, "commands.auction.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]);
            return;
        }
        switch (guiType.ordinal()) {
            case 0: {
                this.openAuctionGUI(player, page);
                break;
            }
            case 1: {
                this.openPlayerItemsGUI(player, page);
                break;
            }
            case 2: {
                this.plugin.getLogger().log(Level.WARNING, "Cannot directly open REMOVE_CONFIRM GUI. Use openRemoveConfirmGUI() instead.");
                this.openPlayerItemsGUI(player, 1);
            }
        }
    }

    private void setCurrentPage(UUID playerId, int page) {
        this.playerPageMap.put(playerId, page);
    }

    private int getCurrentPage(UUID playerId, GUIType guiType) {
        return this.playerPageMap.getOrDefault(playerId, 1);
    }

    public void openAuctionGUI(Player player, int page) {
        if (!this.economyManager.isEnabled()) {
            this.sendTranslatedMessage(player, "commands.auction.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]);
            return;
        }
        UUID playerId = player.getUniqueId();
        ((CompletableFuture)this.storage.getAllActiveItems().thenAccept(items -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            try {
                this.openAuctionGUISync(player, page, (List<AuctionItem>)items);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to open auction GUI", e);
                this.sendTranslatedMessage(player, "commands.error", "<red>An error occurred. Please try again.", new LanguageManager.ComponentPlaceholder[0]);
            }
        }))).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to load auction items", (Throwable)ex);
            return null;
        });
    }

    private void openAuctionGUISync(Player player, int page, List<AuctionItem> items) {
        UUID playerId = player.getUniqueId();
        items = this.filterExpired(items);
        int totalPages = Math.max(1, (int)Math.ceil((double)items.size() / (double)this.config.itemsPerPage));
        page = Math.min(page, totalPages);
        this.setCurrentPage(playerId, page);
        Component title = this.getTranslatedComponent(player, "commands.auction.gui.titles.auction", "<green>Auction House - Page {page}", LanguageManager.ComponentPlaceholder.of("{page}", String.valueOf(page)));
        Inventory inv = Bukkit.createInventory((InventoryHolder)new AuctionGUIHolder(GUIType.AUCTION_HOUSE, page), (int)(this.config.guiRows * 9), (Component)title);
        this.addBorder(inv);
        HashMap<Integer, UUID> slotMap = new HashMap<Integer, UUID>();
        int start = (page - 1) * this.config.itemsPerPage;
        int end = Math.min(start + this.config.itemsPerPage, items.size());
        for (int i = start; i < end; ++i) {
            AuctionItem item = items.get(i);
            int slot = this.getSlot(i - start);
            slotMap.put(slot, item.getId());
            inv.setItem(slot, this.createDisplayItem(player, item, false));
        }
        this.auctionViewingMap.put(playerId, slotMap);
        this.playerGUITypeMap.put(playerId, GUIType.AUCTION_HOUSE);
        inv.setItem(45, this.createNavigationItem(player, Material.ARROW, GuiItemType.PREVIOUS_PAGE, "commands.auction.gui.navigation.prev", "<yellow>\u2190 Previous Page"));
        inv.setItem(0, this.createNavigationItem(player, Material.PAPER, GuiItemType.REFRESH, "commands.auction.gui.navigation.refresh", "<aqua>\u21bb Refresh"));
        inv.setItem(4, this.createPlayerBalanceItem(player));
        inv.setItem(8, this.createNavigationItem(player, Material.CHEST, GuiItemType.MY_ITEMS, "commands.auction.gui.navigation.my-items", "<gold>\u2630 My Items"));
        inv.setItem(49, this.createNavigationItem(player, Material.BARRIER, GuiItemType.CLOSE, "commands.auction.gui.navigation.close", "<red>\u2715 Close"));
        inv.setItem(53, this.createNavigationItem(player, Material.ARROW, GuiItemType.NEXT_PAGE, "commands.auction.gui.navigation.next", "<yellow>Next Page \u2192"));
        player.openInventory(inv);
    }

    public void openPlayerItemsGUI(Player player, int page) {
        if (!this.economyManager.isEnabled()) {
            this.sendTranslatedMessage(player, "commands.auction.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]);
            return;
        }
        UUID playerId = player.getUniqueId();
        ((CompletableFuture)this.storage.getPlayerItems(playerId).thenAccept(items -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            try {
                this.openPlayerItemsGUISync(player, page, (List<AuctionItem>)items);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to open player items GUI", e);
                this.sendTranslatedMessage(player, "general.error", "<red>An error occurred. Please try again.", new LanguageManager.ComponentPlaceholder[0]);
            }
        }))).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "[Auction] Failed to load player items", (Throwable)ex);
            return null;
        });
    }

    private void openPlayerItemsGUISync(Player player, int page, List<AuctionItem> items) {
        UUID playerId = player.getUniqueId();
        items = this.filterExpired(items);
        int totalPages = Math.max(1, (int)Math.ceil((double)items.size() / (double)this.config.itemsPerPage));
        page = Math.min(page, totalPages);
        this.setCurrentPage(playerId, page);
        Component title = this.getTranslatedComponent(player, "commands.auction.gui.titles.my-items", "<green>Your Items - Page {page}", LanguageManager.ComponentPlaceholder.of("{page}", String.valueOf(page)));
        Inventory inv = Bukkit.createInventory((InventoryHolder)new AuctionGUIHolder(GUIType.PLAYER_ITEMS, page), (int)(this.config.guiRows * 9), (Component)title);
        this.addBorder(inv);
        HashMap<Integer, UUID> slotMap = new HashMap<Integer, UUID>();
        int start = (page - 1) * this.config.itemsPerPage;
        int end = Math.min(start + this.config.itemsPerPage, items.size());
        for (int i = start; i < end; ++i) {
            AuctionItem item = items.get(i);
            int slot = this.getSlot(i - start);
            slotMap.put(slot, item.getId());
            inv.setItem(slot, this.createDisplayItem(player, item, true));
        }
        this.playerItemsViewingMap.put(playerId, slotMap);
        this.playerGUITypeMap.put(playerId, GUIType.PLAYER_ITEMS);
        inv.setItem(45, this.createNavigationItem(player, Material.ARROW, GuiItemType.PREVIOUS_PAGE, "commands.auction.gui.navigation.prev", "<yellow>\u2190 Previous Page"));
        inv.setItem(53, this.createNavigationItem(player, Material.ARROW, GuiItemType.NEXT_PAGE, "commands.auction.gui.navigation.next", "<yellow>Next Page \u2192"));
        inv.setItem(49, this.createNavigationItem(player, Material.BARRIER, GuiItemType.CLOSE, "commands.auction.gui.navigation.close", "<red>\u2715 Close"));
        player.openInventory(inv);
    }

    private void openRemoveConfirmGUI(Player player) {
        Component title = this.getTranslatedComponent(player, "commands.auction.gui.titles.remove-confirm", "<red>Confirm Removal", new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new AuctionGUIHolder(GUIType.REMOVE_CONFIRM, 1), (int)27, (Component)title);
        inv.setItem(11, this.createNavigationItem(player, Material.GREEN_WOOL, GuiItemType.CONFIRM_REMOVE, "commands.auction.gui.remove.confirm", "<green>\u2713 Confirm Removal"));
        inv.setItem(15, this.createNavigationItem(player, Material.RED_WOOL, GuiItemType.CANCEL_REMOVE, "commands.auction.gui.remove.cancel", "<red>\u2717 Cancel"));
        this.playerGUITypeMap.put(player.getUniqueId(), GUIType.REMOVE_CONFIRM);
        player.openInventory(inv);
    }

    private ItemStack createNavigationItem(Player player, Material material, GuiItemType itemType, String messageKey, String defaultValue) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        Component nameComponent = this.getTranslatedComponent(player, messageKey, defaultValue, new LanguageManager.ComponentPlaceholder[0]);
        meta.displayName(nameComponent);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.guiItemKey, PersistentDataType.BYTE, (Object)1);
        container.set(this.guiItemTypeKey, PersistentDataType.STRING, (Object)itemType.name());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createDisplayItem(Player player, AuctionItem item, boolean forSeller) {
        ItemStack display = item.getItem().clone();
        ItemMeta meta = display.getItemMeta();
        if (meta == null) {
            return display;
        }
        Component nameComponent = this.getTranslatedComponent(player, "commands.auction.gui.item.name", "<green>Price: <yellow>${price}", LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(item.getPrice())));
        meta.displayName(nameComponent);
        ArrayList<Component> lore = new ArrayList<Component>();
        if (forSeller) {
            lore.add(this.getTranslatedComponent(player, "commands.auction.gui.item.lore.seller-price", "<gray>Your price: <yellow>${price}", LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(item.getPrice()))));
        } else {
            lore.add(this.getTranslatedComponent(player, "commands.auction.gui.item.lore.seller", "<gray>Seller: <yellow>{seller}", LanguageManager.ComponentPlaceholder.of("{seller}", this.getSellerName(item.getSeller()))));
        }
        lore.add(this.getTranslatedComponent(player, "commands.auction.gui.item.lore.expires", "<gray>Expires: <yellow>{date}", LanguageManager.ComponentPlaceholder.of("{date}", this.formatDate(item.getExpiration()))));
        String clickMessageKey = forSeller ? "commands.auction.gui.item.lore.seller-click" : "commands.auction.gui.item.lore.buyer-click";
        String clickDefault = forSeller ? "<yellow>Click to remove" : "<yellow>Click to purchase";
        lore.add(this.getTranslatedComponent(player, clickMessageKey, clickDefault, new LanguageManager.ComponentPlaceholder[0]));
        meta.lore(lore);
        display.setItemMeta(meta);
        return display;
    }

    private ItemStack createPlayerBalanceItem(Player player) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta == null) {
            return skull;
        }
        double balance = this.economyManager.getBalance(player);
        Component nameComponent = this.getTranslatedComponent(player, "commands.auction.gui.balance.item-name", "<green>Balance: <yellow>${balance}", LanguageManager.ComponentPlaceholder.of("{balance}", this.economyManager.format(balance)));
        meta.displayName(nameComponent);
        meta.setOwningPlayer((OfflinePlayer)player);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private void addBorder(Inventory inv) {
        int i;
        ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta meta = glass.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.displayName((Component)Component.empty());
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.guiItemKey, PersistentDataType.BYTE, (Object)1);
        container.set(this.guiItemTypeKey, PersistentDataType.STRING, (Object)GuiItemType.BORDER.name());
        glass.setItemMeta(meta);
        int size = inv.getSize();
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, glass);
        }
        for (i = size - 9; i < size; ++i) {
            inv.setItem(i, glass);
        }
        for (i = 9; i < size - 9; i += 9) {
            inv.setItem(i, glass);
            inv.setItem(i + 8, glass);
        }
    }

    private int getSlot(int index) {
        return (index / 7 + 1) * 9 + index % 7 + 1;
    }

    private String getSellerName(UUID sellerId) {
        return Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)sellerId).getName()).orElse("Unknown");
    }

    private String formatDate(long timestamp) {
        try {
            return LocalDate.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to format date: " + timestamp, e);
            return "Unknown";
        }
    }

    private List<AuctionItem> filterExpired(List<AuctionItem> items) {
        long now = System.currentTimeMillis();
        return items.stream().filter(item -> item.getExpiration() > now).toList();
    }

    private void sendTranslatedMessage(Player player, String key, String defaultValue, LanguageManager.ComponentPlaceholder ... placeholders) {
        try {
            Component message = this.langManager.getMessageFor(player, key, defaultValue, placeholders);
            if (message == null) {
                this.plugin.getLogger().log(Level.WARNING, "Translation resulted in null for key: " + key);
                message = this.miniMessage.deserialize(defaultValue);
            }
            player.sendMessage(message);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to send translated message for key: " + key, e);
            player.sendMessage(this.miniMessage.deserialize(defaultValue));
        }
    }

    private Component getTranslatedComponent(Player player, String key, String defaultValue, LanguageManager.ComponentPlaceholder ... placeholders) {
        try {
            Component component = this.langManager.getMessageFor(player, key, defaultValue, placeholders);
            if (component == null) {
                this.plugin.getLogger().log(Level.WARNING, "Component translation resulted in null for key: " + key);
                return this.miniMessage.deserialize(defaultValue);
            }
            return component;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to translate component for key: " + key, e);
            return this.miniMessage.deserialize(defaultValue);
        }
    }

    private boolean isInGUITransition(UUID playerId) {
        return this.pendingRemovalMap.containsKey(playerId);
    }

    public static class AuctionGUIHolder
    implements InventoryHolder {
        private final GUIType guiType;
        private final int page;

        public AuctionGUIHolder(GUIType guiType, int page) {
            this.guiType = guiType;
            this.page = page;
        }

        public GUIType getGuiType() {
            return this.guiType;
        }

        public int getPage() {
            return this.page;
        }

        public Inventory getInventory() {
            return null;
        }
    }

    public static enum GUIType {
        AUCTION_HOUSE,
        PLAYER_ITEMS,
        REMOVE_CONFIRM;

    }

    public static enum GuiItemType {
        PREVIOUS_PAGE,
        NEXT_PAGE,
        REFRESH,
        MY_ITEMS,
        CLOSE,
        BALANCE_INFO,
        CONFIRM_REMOVE,
        CANCEL_REMOVE,
        BORDER;

    }
}

