/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.auction.api;

import com.serveressentials.api.auction.AuctionAPI;
import com.serveressentials.api.auction.event.AuctionListEvent;
import com.serveressentials.api.auction.event.AuctionRemoveEvent;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.auction.gui.AuctionGUIListener;
import net.godlycow.org.auction.model.AuctionItem;
import net.godlycow.org.auction.storage.AuctionStorage;
import net.godlycow.org.commands.config.AuctionConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AuctionAPIImpl
implements AuctionAPI {
    private final AuctionConfig config;
    private final AuctionGUIListener guiListener;
    private final AuctionStorage storage;
    private final EconomyManager economyManager;
    private final EssC plugin;

    public AuctionAPIImpl(EssC plugin, AuctionConfig config, AuctionGUIListener guiListener, AuctionStorage storage, EconomyManager economyManager) {
        this.plugin = plugin;
        this.config = config;
        this.guiListener = guiListener;
        this.storage = storage;
        this.economyManager = economyManager;
    }

    @Override
    public void openAuction(Player player) {
        if (!this.config.enabled || !this.economyManager.isEnabled()) {
            this.plugin.getLogger().log(Level.WARNING, "Auction system disabled when opening GUI for " + player.getName());
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.guiListener.openAuctionGUI(player, 1));
    }

    @Override
    public void openMyAuctionItems(Player player) {
        if (!this.config.enabled || !this.economyManager.isEnabled()) {
            this.plugin.getLogger().log(Level.WARNING, "Auction system disabled when opening player items for " + player.getName());
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.guiListener.openPlayerItemsGUI(player, 1));
    }

    @Override
    public CompletableFuture<Boolean> addAuctionItem(Player seller, ItemStack item, double price) {
        if (!this.config.enabled || !this.economyManager.isEnabled()) {
            this.plugin.getLogger().log(Level.WARNING, "Auction system disabled when adding item");
            return CompletableFuture.completedFuture(false);
        }
        if (price <= 0.0 || price > this.getMaxPriceLimit()) {
            this.plugin.getLogger().log(Level.WARNING, "Invalid auction price: " + price + " from " + seller.getName());
            return CompletableFuture.completedFuture(false);
        }
        if (item.getAmount() > this.config.maxSellLimit) {
            this.plugin.getLogger().log(Level.WARNING, "Auction item exceeds max limit: " + item.getAmount());
            return CompletableFuture.completedFuture(false);
        }
        long expirationTime = System.currentTimeMillis() + (long)this.config.expirationDays * 24L * 60L * 60L * 1000L;
        AuctionItem internalItem = new AuctionItem(seller.getUniqueId(), item, price, expirationTime);
        return ((CompletableFuture)this.storage.addItem(internalItem).thenApply(v -> {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                AuctionListEvent event = new AuctionListEvent(seller, item, price);
                Bukkit.getPluginManager().callEvent((Event)event);
            });
            return true;
        })).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to add auction item", (Throwable)ex);
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> removeAuctionItem(UUID itemId) {
        if (!this.config.enabled) {
            this.plugin.getLogger().log(Level.WARNING, "Auction system disabled when removing item");
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)this.storage.getItemData(itemId).thenCompose(optItem -> {
            if (optItem.isEmpty()) {
                this.plugin.getLogger().log(Level.WARNING, "Auction item not found for removal: " + String.valueOf(itemId));
                return CompletableFuture.completedFuture(false);
            }
            com.serveressentials.api.auction.AuctionItem apiItem = this.convertToDTO((AuctionItem)optItem.get());
            return this.storage.removeItem(itemId).thenApply(v -> {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Player seller = Bukkit.getPlayer((UUID)apiItem.getSeller());
                    if (seller != null && seller.isOnline()) {
                        AuctionRemoveEvent event = new AuctionRemoveEvent(seller, apiItem.getItem(), itemId);
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                });
                return true;
            });
        })).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to remove auction item", (Throwable)ex);
            return false;
        });
    }

    @Override
    public CompletableFuture<@NotNull List<com.serveressentials.api.auction.AuctionItem>> getActiveItems() {
        return ((CompletableFuture)this.storage.getAllActiveItems().thenApply(items -> items.stream().map(this::convertToDTO).collect(Collectors.toList()))).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get active auction items", (Throwable)ex);
            return List.of();
        });
    }

    @Override
    public CompletableFuture<@NotNull List<com.serveressentials.api.auction.AuctionItem>> getPlayerItems(UUID playerId) {
        return ((CompletableFuture)this.storage.getPlayerItems(playerId).thenApply(items -> items.stream().map(this::convertToDTO).collect(Collectors.toList()))).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get player auction items", (Throwable)ex);
            return List.of();
        });
    }

    @Override
    public boolean isAuctionEnabled() {
        return this.config.enabled && this.economyManager.isEnabled();
    }

    @Override
    public double getMaxPriceLimit() {
        return this.config.maxPriceLimit;
    }

    @Override
    public int getMaxItemsPerPlayer() {
        return this.config.maxItemsPerPlayer;
    }

    private com.serveressentials.api.auction.AuctionItem convertToDTO(AuctionItem internal) {
        return new com.serveressentials.api.auction.AuctionItem(internal.getId(), internal.getSeller(), internal.getItem(), internal.getPrice(), internal.getExpiration(), 0L);
    }
}

