/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.afk.api;

import com.serveressentials.api.afk.AFKAPI;
import com.serveressentials.api.afk.event.AFKStatusEvent;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.EssC;
import net.godlycow.org.afk.AFKManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class AFKAPIImpl
implements AFKAPI {
    private final AFKManager afkManager;
    private final EssC plugin;

    public AFKAPIImpl(EssC plugin, AFKManager afkManager) {
        this.plugin = plugin;
        this.afkManager = afkManager;
    }

    @Override
    public boolean isAFK(Player player) {
        return this.afkManager.isAFK(player);
    }

    @Override
    public CompletableFuture<Boolean> setAFK(Player player, boolean afk) {
        return CompletableFuture.supplyAsync(() -> {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.afkManager.setAFK(player, afk);
                AFKStatusEvent event = new AFKStatusEvent(player, afk);
                Bukkit.getPluginManager().callEvent((Event)event);
            });
            return true;
        });
    }

    @Override
    public CompletableFuture<Boolean> toggleAFK(Player player) {
        return this.setAFK(player, !this.isAFK(player));
    }

    @Override
    public Collection<UUID> getAFKPlayers() {
        return this.afkManager.getAFKPlayers();
    }

    @Override
    public long getAFKTimeoutSeconds() {
        return this.afkManager.getAFKTimeoutSeconds();
    }

    @Override
    public boolean isAFKEnabled() {
        return this.afkManager.isAFKEnabled();
    }

    @Override
    public void updatePlayerActivity(Player player) {
        this.afkManager.updateActivity(player);
    }
}

