/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.afk;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.config.AFKConfig;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class AFKManager
implements Listener {
    private final MiniMessage mini = MiniMessage.miniMessage();
    private final Map<UUID, Long> lastActivity = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastMoveTime = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> afkPlayers = ConcurrentHashMap.newKeySet();
    private final Map<UUID, BossBar> bossBars = new ConcurrentHashMap<UUID, BossBar>();
    private BukkitTask checkTask;
    private final Plugin plugin;
    private final AFKConfig config;
    private static final long STILLNESS_THRESHOLD_MS = 5000L;

    public AFKManager(Plugin plugin, AFKConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.loadOnlinePlayers();
        this.startCheckTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    private void loadOnlinePlayers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            long currentTime = System.currentTimeMillis();
            this.lastActivity.put(player.getUniqueId(), currentTime);
            this.lastMoveTime.put(player.getUniqueId(), currentTime);
        });
    }

    private void startCheckTask() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.checkTask = Bukkit.getScheduler().runTaskTimer(this.plugin, this::checkAFK, 20L, 20L);
    }

    private void checkAFK() {
        if (!this.config.enabled) {
            return;
        }
        long timeoutMillis = this.config.timeoutSeconds * 1000L;
        long currentTime = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uuid = player.getUniqueId();
            if (this.config.exemptWorlds.contains(player.getWorld().getName()) || player.hasPermission("essc.command.afk.exempt")) continue;
            long lastActive = this.lastActivity.getOrDefault(uuid, currentTime);
            long lastMove = this.lastMoveTime.getOrDefault(uuid, currentTime);
            long timeSinceLastActivity = currentTime - lastActive;
            long timeSinceLastMove = currentTime - lastMove;
            if (this.afkPlayers.contains(uuid) || timeSinceLastMove < 5000L || timeSinceLastActivity < timeoutMillis) continue;
            this.plugin.getLogger().info("[AFK] Auto-marking " + player.getName() + " as AFK");
            this.setAFK(player, true);
        }
    }

    public void setAFK(Player player, boolean afk) {
        UUID uuid = player.getUniqueId();
        if (afk) {
            World w;
            this.afkPlayers.add(uuid);
            this.lastActivity.put(uuid, System.currentTimeMillis());
            this.sendMessage(player, this.config.broadcastEnabled, (Component)this.mini.deserialize(this.config.enterMessage.replace("%player%", player.getName())));
            if (this.config.actionBarEnabled) {
                player.sendActionBar(this.mini.deserialize(this.config.actionBarText.replace("%player%", player.getName())));
            }
            if (this.config.bossbarEnabled) {
                this.showBossBar(player);
            }
            if (this.config.disableFlight) {
                player.setFlying(false);
            }
            this.applyTablistModification(player, true);
            if (this.config.kickOnAFK) {
                player.kick(this.mini.deserialize(this.config.kickMessage));
                return;
            }
            if (this.config.teleportOnAFK && (w = Bukkit.getWorld((String)this.config.teleportWorld)) != null) {
                player.teleport(new Location(w, this.config.teleportX, this.config.teleportY, this.config.teleportZ));
            }
            if (this.config.soundsEnabled) {
                try {
                    player.playSound(player.getLocation(), Sound.valueOf((String)this.config.soundName), 1.0f, 1.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.config.particlesEnabled) {
                try {
                    player.getWorld().spawnParticle(Particle.valueOf((String)this.config.particleName), player.getLocation(), 30, 0.5, 1.0, 0.5, 0.01);
                }
                catch (Exception exception) {}
            }
        } else {
            this.afkPlayers.remove(uuid);
            this.removeBossBar(player);
            this.applyTablistModification(player, false);
            this.sendMessage(player, this.config.broadcastEnabled, (Component)this.mini.deserialize(this.config.leaveMessage.replace("%player%", player.getName())));
            if (this.config.actionBarEnabled) {
                player.sendActionBar(this.mini.deserialize(this.config.actionBarText.replace("%player%", player.getName())));
            }
        }
    }

    public void toggleAFK(Player player) {
        this.setAFK(player, !this.isAFK(player));
    }

    private void applyTablistModification(Player player, boolean afk) {
        if (!this.config.modifyTablist) {
            return;
        }
        if (afk) {
            Object name = this.mini.deserialize(this.config.tablistPrefix + player.getName() + this.config.tablistSuffix);
            player.playerListName(name);
        } else {
            player.playerListName((Component)Component.text(player.getName()));
        }
    }

    private void sendMessage(Player player, boolean broadcast, Component component) {
        if (broadcast) {
            Bukkit.getServer().sendMessage(component);
        } else {
            player.sendMessage(component);
        }
    }

    private void showBossBar(Player player) {
        if (!this.config.bossbarEnabled) {
            return;
        }
        try {
            BossBar bar = BossBar.bossBar(this.mini.deserialize(this.config.bossbarText.replace("%player%", player.getName())), 1.0f, BossBar.Color.valueOf(this.config.bossbarColor.toUpperCase()), BossBar.Overlay.valueOf(this.config.bossbarStyle.toUpperCase()));
            this.bossBars.put(player.getUniqueId(), bar);
            player.showBossBar(bar);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to create BossBar for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void removeBossBar(Player player) {
        BossBar bar = this.bossBars.remove(player.getUniqueId());
        if (bar != null) {
            player.hideBossBar(bar);
        }
    }

    public void reload() {
        this.lastActivity.clear();
        this.lastMoveTime.clear();
        this.afkPlayers.clear();
        this.bossBars.values().forEach(bar -> Bukkit.getOnlinePlayers().forEach(p -> p.hideBossBar(bar)));
        this.bossBars.clear();
        this.loadOnlinePlayers();
        this.startCheckTask();
    }

    public boolean isAFK(Player player) {
        return this.afkPlayers.contains(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        long currentTime = System.currentTimeMillis();
        this.lastActivity.put(e.getPlayer().getUniqueId(), currentTime);
        this.lastMoveTime.put(e.getPlayer().getUniqueId(), currentTime);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        UUID u = e.getPlayer().getUniqueId();
        this.lastActivity.remove(u);
        this.lastMoveTime.remove(u);
        this.afkPlayers.remove(u);
        this.removeBossBar(e.getPlayer());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (!e.getFrom().getBlock().equals((Object)e.getTo().getBlock())) {
            Player player = e.getPlayer();
            UUID uuid = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            this.lastMoveTime.put(uuid, currentTime);
            this.lastActivity.put(uuid, currentTime);
            if (this.afkPlayers.contains(uuid)) {
                this.plugin.getLogger().info("[AFK] Removing AFK from " + player.getName() + " due to movement");
                this.setAFK(player, false);
            }
        }
    }

    public Collection<UUID> getAFKPlayers() {
        return Set.copyOf(this.afkPlayers);
    }

    public long getAFKTimeoutSeconds() {
        return this.config.timeoutSeconds;
    }

    public boolean isAFKEnabled() {
        return this.config.enabled;
    }

    public void updateActivity(Player player) {
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        this.lastActivity.put(uuid, currentTime);
        this.lastMoveTime.put(uuid, currentTime);
        if (this.afkPlayers.contains(uuid)) {
            this.setAFK(player, false);
        }
    }
}

