/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.PlaceholderAPI;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.godlycow.org.EssC;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EssentialsCPlaceholderExpansion
extends PlaceholderExpansion {
    private final EssC plugin;

    public EssentialsCPlaceholderExpansion(EssC plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "se";
    }

    @NotNull
    public String getAuthor() {
        return ":_GodlyCow";
    }

    @NotNull
    public String getVersion() {
        return "2.0.8.1";
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(OfflinePlayer offlinePlayer, @NotNull String identifier) {
        if (identifier == null) {
            return "";
        }
        String id = identifier.toLowerCase();
        if (id.startsWith("playtime_top_")) {
            return this.handleTopPlaytimePlaceholder(id);
        }
        if (offlinePlayer == null || !offlinePlayer.isOnline()) {
            return "";
        }
        Player player = offlinePlayer.getPlayer();
        if (player == null) {
            return "";
        }
        switch (id) {
            case "playtime": {
                return this.formatTime(this.getPlaytimeInSeconds(player));
            }
            case "isop": {
                return player.isOp() ? "Yes" : "No";
            }
            case "deaths": {
                return String.valueOf(this.getStatisticSafe(player, Statistic.DEATHS));
            }
            case "blocks_broken": {
                return String.valueOf(this.calculateBlocksBroken(player));
            }
            case "blocks_placed": {
                return String.valueOf(this.calculateBlocksPlaced(player));
            }
            case "kills": {
                return String.valueOf(this.getStatisticSafe(player, Statistic.PLAYER_KILLS));
            }
        }
        return "";
    }

    private long getPlaytimeInSeconds(Player player) {
        try {
            long ticks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
            return ticks / 20L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private int getStatisticSafe(Player player, Statistic statistic) {
        try {
            return player.getStatistic(statistic);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int calculateBlocksBroken(Player player) {
        int broken = 0;
        for (Material material : Material.values()) {
            try {
                broken += player.getStatistic(Statistic.MINE_BLOCK, material);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return broken;
    }

    private int calculateBlocksPlaced(Player player) {
        int placed = 0;
        for (Material material : Material.values()) {
            try {
                placed += player.getStatistic(Statistic.USE_ITEM, material);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return placed;
    }

    private String handleTopPlaytimePlaceholder(String identifier) {
        try {
            int rank = Integer.parseInt(identifier.substring("playtime_top_".length()));
            List<Map.Entry<UUID, Long>> top = this.plugin.getPlaytimeManager().getTopPlaytimes(rank);
            if (rank > 0 && rank <= top.size()) {
                Map.Entry<UUID, Long> entry = top.get(rank - 1);
                UUID targetUUID = entry.getKey();
                long seconds = entry.getValue();
                OfflinePlayer topPlayer = Bukkit.getOfflinePlayer((UUID)targetUUID);
                String name = topPlayer.getName() != null ? topPlayer.getName() : "Unknown";
                return name + ": " + this.formatTime(seconds);
            }
            return "N/A";
        }
        catch (NumberFormatException e) {
            return "Invalid number";
        }
        catch (Exception e) {
            return "Error";
        }
    }

    private String formatTime(long totalSeconds) {
        if (totalSeconds < 0L) {
            return "0s";
        }
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString().trim();
    }
}

