/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FirstJoinManager
implements Listener,
CommandExecutor,
TabExecutor {
    private final JavaPlugin plugin;
    private final NamespacedKey KEY_PROCESSED;
    private final NamespacedKey KEY_ITEM_CMD;
    private final MiniMessage MINI = MiniMessage.miniMessage();
    private final BukkitAudiences adventure;
    private final boolean adventurePresent;
    private File configFile;
    private FileConfiguration cfg;
    private final Map<String, GUI> guiCache = new HashMap<String, GUI>();
    private final NamespacedKey KEY_ITEM_GUI;
    private static final NamespacedKey KEY_GUI_CMD = new NamespacedKey((Plugin)JavaPlugin.getProvidingPlugin(FirstJoinManager.class), "gui_cmd");

    public FirstJoinManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.KEY_PROCESSED = new NamespacedKey((Plugin)plugin, "fj_done");
        this.KEY_ITEM_CMD = new NamespacedKey((Plugin)plugin, "fj_item_cmd");
        this.KEY_ITEM_GUI = new NamespacedKey((Plugin)plugin, "fj_open_gui");
        BukkitAudiences tempAdventure = null;
        boolean tempPresent = false;
        try {
            tempAdventure = BukkitAudiences.create((Plugin)plugin);
            tempPresent = true;
        }
        catch (Throwable t) {
            plugin.getLogger().info("Adventure not found \u2013 falling back to legacy colours.");
        }
        this.adventure = tempAdventure;
        this.adventurePresent = tempPresent;
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Objects.requireNonNull(plugin.getCommand("firstjoin")).setExecutor((CommandExecutor)this);
    }

    private void loadConfig() {
        this.configFile = new File(this.plugin.getDataFolder(), "FJ.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("FJ.yml", false);
        }
        this.cfg = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.guiCache.clear();
        ConfigurationSection guiSection = this.cfg.getConfigurationSection("guis");
        if (guiSection != null) {
            for (String key : guiSection.getKeys(false)) {
                this.guiCache.put(key.toLowerCase(Locale.ROOT), new GUI(key, guiSection.getConfigurationSection(key)));
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.getPersistentDataContainer().has(this.KEY_PROCESSED, PersistentDataType.BYTE)) {
            return;
        }
        if (p.hasPlayedBefore()) {
            return;
        }
        p.getPersistentDataContainer().set(this.KEY_PROCESSED, PersistentDataType.BYTE, (Object)1);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.runFirstJoin(p), 1L);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("essc.command.firstjoin.reload")) {
                sender.sendMessage("\u00a7cNo permission.");
                return true;
            }
            this.loadConfig();
            sender.sendMessage("\u00a7aFJ.yml reloaded.");
            return true;
        }
        if (args[0].equalsIgnoreCase("gui")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cPlayer only.");
                return true;
            }
            Player p = (Player)sender;
            if (!sender.hasPermission("firstjoin.gui")) {
                sender.sendMessage("\u00a7cNo permission.");
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /firstjoin gui <id>");
                return true;
            }
            GUI gui = this.guiCache.get(args[1].toLowerCase(Locale.ROOT));
            if (gui == null) {
                sender.sendMessage("\u00a7cUnknown GUI '" + args[1] + "'.");
                return true;
            }
            gui.open(p);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 1) {
            return List.of("reload", "gui");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("gui")) {
            return new ArrayList<String>(this.guiCache.keySet());
        }
        return Collections.emptyList();
    }

    private void runFirstJoin(Player p) {
        GUI gui;
        String guiId;
        Map m;
        Map raw2;
        Object t;
        if (this.cfg.isConfigurationSection("titles")) {
            t = this.cfg.getConfigurationSection("titles");
            this.sendTitle(p, t.getString("title", ""), t.getString("subtitle", ""), t.getInt("fade-in", 10), t.getInt("stay", 70), t.getInt("fade-out", 20));
        }
        if (this.cfg.isList("bossbars")) {
            for (Map raw2 : this.cfg.getMapList("bossbars")) {
                new BossBarRunner(p, raw2).start();
            }
        }
        this.applyEffects(p);
        if (this.cfg.isList("particles")) {
            t = this.cfg.getMapList("particles").iterator();
            while (t.hasNext()) {
                m = raw2 = (Map)t.next();
                this.spawnParticles(p, m);
            }
        }
        if (this.cfg.isList("commands")) {
            t = this.cfg.getMapList("commands").iterator();
            while (t.hasNext()) {
                m = raw2 = (Map)t.next();
                this.runCommand(p, m.getOrDefault("run_as", "console"), (String)m.get("command"), ((Number)m.getOrDefault("delay_ticks", 0)).intValue());
            }
        }
        if (this.cfg.isList("items")) {
            for (Map raw2 : this.cfg.getMapList("items")) {
                this.giveItem(p, raw2);
            }
        }
        if (this.cfg.isList("messages")) {
            for (String line : this.cfg.getStringList("messages")) {
                this.sendMessage(p, line);
            }
        }
        if ((guiId = this.cfg.getString("open_gui")) != null && (gui = this.guiCache.get(guiId.toLowerCase(Locale.ROOT))) != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> gui.open(p), 2L);
        }
    }

    private void applyEffects(Player p) {
        if (!this.cfg.isList("effects")) {
            return;
        }
        Iterator iterator = this.cfg.getMapList("effects").iterator();
        while (iterator.hasNext()) {
            Map raw;
            Map m = raw = (Map)iterator.next();
            String type = m.getOrDefault("type", "SPEED");
            int amp = ((Number)m.getOrDefault("amplifier", 1)).intValue();
            int dur = ((Number)m.getOrDefault("duration_seconds", 10)).intValue();
            PotionEffectType pet = PotionEffectType.getByName((String)type.toUpperCase(Locale.ROOT));
            if (pet == null) {
                this.plugin.getLogger().warning("Invalid effect: " + type);
                continue;
            }
            p.addPotionEffect(new PotionEffect(pet, dur * 20, Math.max(0, amp - 1)));
        }
    }

    private void spawnParticles(Player p, Map<String, Object> m) {
        Particle particle;
        String name = (String)m.getOrDefault("particle", "VILLAGER_HAPPY");
        try {
            particle = Particle.valueOf((String)name.toUpperCase(Locale.ROOT));
        }
        catch (Exception ex) {
            particle = Particle.GLOW;
        }
        final Location loc = p.getLocation().add(0.0, 1.0, 0.0);
        final int count = ((Number)m.getOrDefault("count", 10)).intValue();
        final double ox = ((Number)m.getOrDefault("offset_x", 0.0)).doubleValue();
        final double oy = ((Number)m.getOrDefault("offset_y", 0.0)).doubleValue();
        final double oz = ((Number)m.getOrDefault("offset_z", 0.0)).doubleValue();
        int duration = ((Number)m.getOrDefault("duration_seconds", 4)).intValue();
        final int runs = Math.max(1, duration * 4);
        final Particle finalParticle = particle;
        new BukkitRunnable(this){
            int i = 0;

            public void run() {
                loc.getWorld().spawnParticle(finalParticle, loc, count, ox, oy, oz);
                if (++this.i >= runs) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 5L);
    }

    private void giveItem(Player p, Map<String, Object> map) {
        List flags;
        ConfigurationSection enchSec;
        Material mat;
        String matName = (String)map.getOrDefault("material", "STONE");
        try {
            mat = Material.valueOf((String)matName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            this.plugin.getLogger().warning("FJ.yml unknown material: " + matName);
            return;
        }
        int amount = Math.max(1, ((Number)map.getOrDefault("amount", 1)).intValue());
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            p.getInventory().addItem(new ItemStack[]{item});
            return;
        }
        if (map.containsKey("name")) {
            meta.displayName(this.parse(p, (String)map.get("name")));
        }
        if (map.containsKey("lore")) {
            List lines = (List)map.get("lore");
            meta.lore(lines.stream().map(s -> this.parse(p, (String)s)).toList());
        }
        if ((enchSec = (ConfigurationSection)map.get("enchants")) != null) {
            for (String key : enchSec.getKeys(false)) {
                Enchantment ench = Enchantment.getByName((String)key.toUpperCase(Locale.ROOT));
                if (ench == null) continue;
                meta.addEnchant(ench, enchSec.getInt(key), true);
            }
        }
        if ((flags = (List)map.get("flags")) != null) {
            flags.forEach(f -> {
                try {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)f.toUpperCase(Locale.ROOT))});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        meta.setUnbreakable(((Boolean)map.getOrDefault("unbreakable", false)).booleanValue());
        if (map.containsKey("custom_model_data")) {
            try {
                meta.setCustomModelData(Integer.valueOf(((Number)map.get("custom_model_data")).intValue()));
            }
            catch (Exception key) {
                // empty catch block
            }
        }
        if (map.containsKey("on_use_commands")) {
            List cmds = (List)map.get("on_use_commands");
            meta.getPersistentDataContainer().set(this.KEY_ITEM_CMD, PersistentDataType.STRING, (Object)String.join((CharSequence)"||", cmds));
        }
        if (map.containsKey("open_gui")) {
            String guiId = ((String)map.get("open_gui")).toLowerCase(Locale.ROOT);
            meta.getPersistentDataContainer().set(this.KEY_ITEM_GUI, PersistentDataType.STRING, (Object)guiId);
        }
        item.setItemMeta(meta);
        int slot = ((Number)map.getOrDefault("slot", -1)).intValue();
        if (slot >= 0 && slot < p.getInventory().getSize()) {
            p.getInventory().setItem(slot, item);
        } else {
            p.getInventory().addItem(new ItemStack[]{item});
        }
    }

    private void runCommand(final Player p, final String runAs, String cmd, int delay) {
        if (cmd == null || cmd.isBlank()) {
            return;
        }
        final String finalCmd = cmd = this.applyPlaceholders(p, cmd);
        BukkitRunnable run = new BukkitRunnable(){

            public void run() {
                FirstJoinManager.this.executeCommand(p, runAs, finalCmd);
            }
        };
        if (delay > 0) {
            run.runTaskLater((Plugin)this.plugin, (long)delay);
        } else {
            run.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Player p, String runAs, String cmd) {
        if ((cmd = cmd.replace("{player}", p.getName()).replace("{uuid}", p.getUniqueId().toString()).replace("{world}", p.getWorld().getName())).toLowerCase().startsWith("give ")) {
            this.handleGive(p, cmd);
            return;
        }
        switch (runAs.toLowerCase()) {
            case "console": {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
                break;
            }
            case "op": {
                boolean was = p.isOp();
                try {
                    p.setOp(true);
                    p.performCommand(cmd);
                    break;
                }
                finally {
                    p.setOp(was);
                }
            }
            case "player": {
                p.performCommand(cmd);
                break;
            }
            default: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            }
        }
    }

    private void handleGive(Player p, String cmd) {
        String[] split = cmd.split(" ");
        if (split.length < 3) {
            return;
        }
        if (!split[1].equalsIgnoreCase(p.getName())) {
            return;
        }
        Material mat = Material.matchMaterial((String)split[2]);
        if (mat == null) {
            p.sendMessage("\u00a7cUnknown material: " + split[2]);
            return;
        }
        int amt = 1;
        if (split.length >= 4) {
            try {
                amt = Integer.parseInt(split[3]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        p.getInventory().addItem(new ItemStack[]{new ItemStack(mat, amt)});
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        GUI gui;
        ItemStack item = e.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String cmds = (String)pdc.get(this.KEY_ITEM_CMD, PersistentDataType.STRING);
        String guiId = (String)pdc.get(this.KEY_ITEM_GUI, PersistentDataType.STRING);
        if (cmds == null && guiId == null) {
            return;
        }
        e.setCancelled(true);
        Player p = e.getPlayer();
        if (cmds != null) {
            for (String part : cmds.split("\\|\\|")) {
                if (part.isBlank()) continue;
                String runAs = "player";
                String command = part;
                if (part.contains(":")) {
                    String[] kv = part.split(":", 2);
                    runAs = kv[0];
                    command = kv[1];
                }
                this.executeCommand(p, runAs, command);
            }
        }
        if (guiId != null && (gui = this.guiCache.get(guiId.toLowerCase(Locale.ROOT))) != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> gui.open(p));
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (!(inventoryHolder instanceof Holder)) {
            return;
        }
        Holder h = (Holder)inventoryHolder;
        e.setCancelled(true);
        if (e.getClickedInventory() != e.getInventory()) {
            return;
        }
        ItemStack item = e.getCurrentItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        String raw = (String)item.getItemMeta().getPersistentDataContainer().get(KEY_GUI_CMD, PersistentDataType.STRING);
        if (raw == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        for (String part : raw.split("\\|\\|")) {
            if (part.isBlank()) continue;
            String runAs = "player";
            String cmd = part;
            if (part.contains(":")) {
                String[] kv = part.split(":", 2);
                runAs = kv[0];
                cmd = kv[1];
            }
            if (cmd.equalsIgnoreCase("close")) {
                p.closeInventory();
                continue;
            }
            this.executeCommand(p, runAs, cmd);
        }
    }

    private ItemStack buildItem(ConfigurationSection sec) {
        ConfigurationSection enchSec;
        Material mat;
        if (sec == null) {
            return null;
        }
        String matName = sec.getString("material", "STONE");
        try {
            mat = Material.valueOf((String)matName.toUpperCase(Locale.ROOT));
        }
        catch (Exception ex) {
            mat = Material.STONE;
        }
        ItemStack item = new ItemStack(mat, Math.max(1, sec.getInt("amount", 1)));
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (sec.contains("name")) {
            meta.displayName(this.parse(null, sec.getString("name")));
        }
        if (sec.contains("lore")) {
            List lore = sec.getStringList("lore");
            meta.lore(lore.stream().map(s -> this.parse(null, (String)s)).toList());
        }
        if ((enchSec = sec.getConfigurationSection("enchants")) != null) {
            for (String k : enchSec.getKeys(false)) {
                Enchantment e = Enchantment.getByName((String)k.toUpperCase(Locale.ROOT));
                if (e == null) continue;
                meta.addEnchant(e, enchSec.getInt(k), true);
            }
        }
        if (sec.contains("flags")) {
            sec.getStringList("flags").forEach(f -> {
                try {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)f.toUpperCase(Locale.ROOT))});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        meta.setUnbreakable(sec.getBoolean("unbreakable", false));
        if (sec.contains("custom_model_data")) {
            try {
                meta.setCustomModelData(Integer.valueOf(sec.getInt("custom_model_data")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sec.contains("commands")) {
            List cmds = sec.getStringList("commands");
            meta.getPersistentDataContainer().set(KEY_GUI_CMD, PersistentDataType.STRING, (Object)String.join((CharSequence)"||", cmds));
        }
        item.setItemMeta(meta);
        return item;
    }

    private void sendTitle(Player p, String title, String subtitle, int in, int stay, int out) {
        if (this.adventurePresent) {
            Audience a = this.adventure.player(p);
            Title.Times times = Title.Times.times(Duration.ofMillis((long)in * 50L), Duration.ofMillis((long)stay * 50L), Duration.ofMillis((long)out * 50L));
            a.showTitle(Title.title(this.parse(p, title), this.parse(p, subtitle), times));
        } else {
            p.sendTitle(this.colorize(this.applyPlaceholders(p, title)), this.colorize(this.applyPlaceholders(p, subtitle)), in, stay, out);
        }
    }

    private void sendMessage(Player p, String raw) {
        Component c = this.parse(p, raw);
        if (this.adventurePresent) {
            this.adventure.player(p).sendMessage(c);
        } else {
            p.sendMessage(LegacyComponentSerializer.legacyAmpersand().serialize(c));
        }
    }

    private Component parse(@Nullable Player p, String input) {
        if (input == null) {
            return Component.empty();
        }
        input = this.applyPlaceholders(p, input);
        if (this.adventurePresent) {
            return this.MINI.deserialize(input);
        }
        return Component.text(this.colorize(input));
    }

    private String applyPlaceholders(Player p, String input) {
        if (input == null) {
            return "";
        }
        if (p != null) {
            input = input.replace("{player}", p.getName()).replace("{display_name}", p.getDisplayName()).replace("{uuid}", p.getUniqueId().toString()).replace("{world}", p.getWorld().getName());
        }
        input = input.replace("{online}", String.valueOf(Bukkit.getOnlinePlayers().size())).replace("{max_players}", String.valueOf(Bukkit.getMaxPlayers()));
        return input;
    }

    private String colorize(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private <E extends Enum<E>> E tryParse(Class<E> clazz, String name, E def) {
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (Exception ex) {
            return def;
        }
    }

    private String legacy(Component c) {
        return LegacyComponentSerializer.legacyAmpersand().serialize(c);
    }

    private final class GUI {
        private final String id;
        private final String title;
        private final int rows;
        private final Map<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();

        GUI(String id, ConfigurationSection sec) {
            this.id = id;
            this.title = sec.getString("title", "GUI");
            this.rows = Math.max(1, Math.min(6, sec.getInt("rows", 3)));
            ConfigurationSection cont = sec.getConfigurationSection("items");
            if (cont != null) {
                for (String key : cont.getKeys(false)) {
                    int slot = Integer.parseInt(key);
                    ItemStack item = FirstJoinManager.this.buildItem(cont.getConfigurationSection(key));
                    if (item == null) continue;
                    this.items.put(slot, item);
                }
            }
        }

        void open(Player p) {
            Inventory inv = Bukkit.createInventory((InventoryHolder)new Holder(this), (int)(this.rows * 9), (Component)FirstJoinManager.this.parse(p, this.title));
            this.items.forEach((arg_0, arg_1) -> ((Inventory)inv).setItem(arg_0, arg_1));
            p.openInventory(inv);
        }
    }

    private final class BossBarRunner {
        private final Player player;
        private final String text;
        private final double seconds;
        private final BarColor color;
        private final BarStyle style;
        private final BossBar bar;

        BossBarRunner(Player p, Map<String, Object> m) {
            this.player = p;
            this.text = (String)m.getOrDefault("text", "&6Welcome");
            this.seconds = ((Number)m.getOrDefault("duration_seconds", 8)).doubleValue();
            String c = ((String)m.getOrDefault("color", "GREEN")).toUpperCase(Locale.ROOT);
            String s = ((String)m.getOrDefault("style", "SOLID")).toUpperCase(Locale.ROOT);
            this.color = FirstJoinManager.this.tryParse(BarColor.class, c, BarColor.GREEN);
            this.style = FirstJoinManager.this.tryParse(BarStyle.class, s, BarStyle.SOLID);
            Component comp = FirstJoinManager.this.parse(this.player, this.text);
            this.bar = Bukkit.createBossBar((String)LegacyComponentSerializer.legacySection().serialize(comp), (BarColor)this.color, (BarStyle)this.style, (BarFlag[])new BarFlag[0]);
        }

        void start() {
            this.bar.addPlayer(this.player);
            final long ticks = Math.max(1L, (long)(this.seconds * 20.0));
            new BukkitRunnable(){
                long i = 0L;

                public void run() {
                    ++this.i;
                    double progress = 1.0 - (double)this.i / (double)ticks;
                    BossBarRunner.this.bar.setProgress(Math.max(0.0, progress));
                    if (this.i >= ticks) {
                        BossBarRunner.this.bar.removePlayer(BossBarRunner.this.player);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)FirstJoinManager.this.plugin, 0L, 1L);
        }
    }

    private static final class Holder
    implements InventoryHolder {
        private final GUI gui;

        Holder(GUI gui) {
            this.gui = gui;
        }

        public Inventory getInventory() {
            return null;
        }
    }
}

